/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.limitedlives.libs.annoyingapi.utility.ConfigurationUtility;

public class PluginPlatform
extends Stringable {
    @NotNull
    public final Platform platform;
    @NotNull
    public final String identifier;
    @Nullable
    public String author;

    public PluginPlatform(@NotNull Platform platform, @NotNull String identifier) {
        this.platform = platform;
        this.identifier = identifier;
        if (platform.requiresAuthor) {
            AnnoyingPlugin.log(Level.WARNING, "&ePlugin platform &6" + (Object)((Object)platform) + "&e requires an author");
        }
    }

    public PluginPlatform(@NotNull Platform platform, @NotNull String identifier, @Nullable String author) {
        this.platform = platform;
        this.identifier = identifier;
        this.author = author;
    }

    @NotNull
    public static Optional<PluginPlatform> load(@NotNull ConfigurationSection section) {
        Platform platform;
        String platformName;
        String name = section.getName();
        String string = platformName = name.isEmpty() ? section.getString("platform") : name;
        if (platformName == null) {
            AnnoyingPlugin.log(Level.WARNING, "&6platform&e is null for section &6" + section.getCurrentPath());
            return Optional.empty();
        }
        try {
            platform = Platform.valueOf(platformName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            AnnoyingPlugin.log(Level.WARNING, "&eInvalid platform &6" + platformName + "&e for section &6" + section.getCurrentPath());
            return Optional.empty();
        }
        String identifier = section.getString("identifier");
        if (identifier == null) {
            AnnoyingPlugin.log(Level.WARNING, "&eidentifier&e is null for platform &6" + platform.name());
            return Optional.empty();
        }
        if (platform.requiresAuthor) {
            String author = section.getString("author");
            if (author == null) {
                AnnoyingPlugin.log(Level.WARNING, "&eauthor&e is null for author-required platform &6" + platform.name() + "&e with identifier &6" + identifier);
                return Optional.empty();
            }
            return Optional.of(new PluginPlatform(platform, identifier, author));
        }
        return Optional.of(new PluginPlatform(platform, identifier));
    }

    @NotNull
    public static PluginPlatform modrinth(@NotNull String identifier) {
        return new PluginPlatform(Platform.MODRINTH, identifier);
    }

    @NotNull
    public static PluginPlatform hangar(@NotNull String identifier, @NotNull String author) {
        return new PluginPlatform(Platform.HANGAR, identifier, author);
    }

    @NotNull
    public static PluginPlatform hangar(@NotNull String identifier, @NotNull Plugin plugin) throws IllegalArgumentException {
        List authors = plugin.getDescription().getAuthors();
        if (authors.isEmpty()) {
            throw new IllegalArgumentException("No authors found for plugin " + plugin.getName() + ", but Hangar requires an author for identifier " + identifier);
        }
        return PluginPlatform.hangar(identifier, (String)authors.get(0));
    }

    @NotNull
    public static PluginPlatform hangar(@NotNull Plugin plugin, @NotNull String author) {
        return PluginPlatform.hangar(plugin.getName(), author);
    }

    @NotNull
    public static PluginPlatform hangar(@NotNull Plugin plugin) throws IllegalArgumentException {
        return PluginPlatform.hangar(plugin.getName(), plugin);
    }

    @NotNull
    public static PluginPlatform spigot(@NotNull String identifier) {
        return new PluginPlatform(Platform.SPIGOT, identifier);
    }

    @NotNull
    public static PluginPlatform bukkit(@NotNull String identifier) {
        return new PluginPlatform(Platform.BUKKIT, identifier);
    }

    @NotNull
    public static PluginPlatform external(@NotNull String identifier) {
        return new PluginPlatform(Platform.EXTERNAL, identifier);
    }

    @NotNull
    public static PluginPlatform manual(@NotNull String identifier) {
        return new PluginPlatform(Platform.MANUAL, identifier);
    }

    public static enum Platform {
        MODRINTH(false),
        HANGAR(true),
        SPIGOT(false),
        BUKKIT(false),
        EXTERNAL(false),
        MANUAL(false);

        public final boolean requiresAuthor;

        private Platform(boolean requiresAuthor) {
            this.requiresAuthor = requiresAuthor;
        }
    }

    public static class Multi
    extends Stringable {
        @NotNull
        public final Set<PluginPlatform> pluginPlatforms = new HashSet<PluginPlatform>();

        public Multi() {
        }

        public Multi(@NotNull Collection<PluginPlatform> pluginPlatforms) {
            pluginPlatforms.forEach(xva$0 -> this.addIfAbsent((PluginPlatform)xva$0));
        }

        public Multi(PluginPlatform ... pluginPlatforms) {
            this(Arrays.asList(pluginPlatforms));
        }

        @NotNull
        public static Multi load(@NotNull ConfigurationSection section, @NotNull String key) {
            Multi multi = new Multi();
            ConfigurationSection platformsSection = section.getConfigurationSection(key);
            if (platformsSection == null) {
                ConfigurationUtility.toConfigurationList(section.getMapList(key)).stream().map(PluginPlatform::load).filter(Optional::isPresent).map(Optional::get).forEach(xva$0 -> multi.addIfAbsent((PluginPlatform)xva$0));
                return multi;
            }
            for (String platformKey : platformsSection.getKeys(false)) {
                ConfigurationSection platformSection = platformsSection.getConfigurationSection(platformKey);
                if (platformSection == null) {
                    String platformKeyString = platformsSection.getString(platformKey);
                    if (platformKeyString == null) continue;
                    try {
                        multi.addIfAbsent(new PluginPlatform(Platform.valueOf(platformKey.toUpperCase()), platformKeyString));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                Optional<PluginPlatform> pluginPlatform = PluginPlatform.load(platformSection);
                pluginPlatform.ifPresent(xva$0 -> multi.addIfAbsent((PluginPlatform)xva$0));
            }
            return multi;
        }

        @NotNull
        public Optional<PluginPlatform> get(@NotNull Platform platform) {
            return this.pluginPlatforms.stream().filter(filter -> filter.platform == platform).findFirst();
        }

        @NotNull
        public Optional<String> getIdentifier(@NotNull Platform platform) {
            return this.get(platform).map(filter -> filter.identifier);
        }

        public boolean add(PluginPlatform ... pluginPlatforms) {
            return this.pluginPlatforms.addAll(Arrays.asList(pluginPlatforms));
        }

        public boolean addIfAbsent(PluginPlatform ... pluginPlatforms) {
            Set toAdd = Arrays.stream(pluginPlatforms).filter(filter -> !this.get(filter.platform).isPresent()).collect(Collectors.toSet());
            return this.pluginPlatforms.addAll(toAdd);
        }

        public boolean remove(Platform ... platforms) {
            List<Platform> toRemove = Arrays.asList(platforms);
            return this.pluginPlatforms.removeIf(filter -> toRemove.contains((Object)filter.platform));
        }

        @Override
        @NotNull
        public String toString() {
            return this.pluginPlatforms.toString();
        }
    }
}

