/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.command.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.AllPlayersSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.EntitiesSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.NearestEntitySelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.NearestPlayerSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.OfflineSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.OnlineSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.RandomEntitySelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.RandomPlayerSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.SelfSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.MapGenerator;

public interface Selector<T> {
    @NotNull
    public static final Map<String, Selector<?>> SELECTORS = MapGenerator.LINKED_HASH_MAP.mapOf("@all_players", new AllPlayersSelector(), "@online", new OnlineSelector(), "@offline", new OfflineSelector(), "@self", new SelfSelector(), "@nearest_player", new NearestPlayerSelector(), "@random_player", new RandomPlayerSelector(), "@entities", new EntitiesSelector(), "@nearest_entity", new NearestEntitySelector(), "@random_entity", new RandomEntitySelector());

    @NotNull
    public Class<T> getType();

    @Nullable
    public List<T> expand(@NotNull AnnoyingSender var1);

    @NotNull
    public static List<String> getKeys() {
        return new ArrayList<String>(SELECTORS.keySet());
    }

    @NotNull
    public static List<String> getKeys(@NotNull Class<?> type) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, Selector<?>> entry : SELECTORS.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getType())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @NotNull
    public static Collection<String> addKeys(@NotNull Collection<String> collection) {
        List<String> result = Selector.getKeys();
        result.addAll(collection);
        return result;
    }

    @NotNull
    public static List<String> addKeys(@NotNull Collection<String> collection, @NotNull Class<?> type) {
        List<String> result = Selector.getKeys(type);
        result.addAll(collection);
        return result;
    }
}

