/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors;

import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.Selector;

public class NearestPlayerSelector
implements Selector<Player> {
    @Override
    @NotNull
    public Class<Player> getType() {
        return Player.class;
    }

    @Override
    @Nullable
    public List<Player> expand(@NotNull AnnoyingSender sender) {
        Player player = sender.getPlayerOrNull();
        if (player == null) {
            return null;
        }
        Location playerLocation = player.getLocation();
        Player nearest = null;
        double nearestDistanceSquared = Double.MAX_VALUE;
        for (Player other : player.getWorld().getPlayers()) {
            double distanceSquared;
            if (other.equals((Object)player) || !((distanceSquared = other.getLocation().distanceSquared(playerLocation)) < nearestDistanceSquared)) continue;
            nearest = other;
            nearestDistanceSquared = distanceSquared;
        }
        return nearest == null ? Collections.emptyList() : Collections.singletonList(nearest);
    }
}

