/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.utility;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.manipulation.Mapper;
import xyz.srnyx.limitedlives.libs.annoyingapi.reflection.org.bukkit.entity.RefEntity;

public class BukkitUtility {
    @NotNull
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)[&\u00a7][0-9A-FK-OR]");

    @NotNull
    public static String color(@Nullable Object object) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf(object));
    }

    @NotNull
    public static List<String> color(@Nullable Object object1, Object ... objects) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BukkitUtility.color(object1));
        for (Object object : objects) {
            list.add(BukkitUtility.color(object));
        }
        return list;
    }

    @NotNull
    public static List<String> colorCollection(@Nullable Collection<?> objects) {
        if (objects == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object object : objects) {
            list.add(BukkitUtility.color(object));
        }
        return list;
    }

    @NotNull
    public static String stripUntranslatedColor(@Nullable String string) {
        return string == null ? "null" : STRIP_COLOR_PATTERN.matcher(string).replaceAll("");
    }

    @NotNull
    public static String hexColor(@NotNull String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        StringBuilder builder = new StringBuilder("&x");
        for (char character : hex.toCharArray()) {
            builder.append('&').append(character);
        }
        return builder.toString();
    }

    public static boolean toggleScoreboardTag(@NotNull Entity entity, @NotNull String scoreboardTag) {
        if (RefEntity.ENTITY_GET_SCOREBOARD_TAGS_METHOD == null || RefEntity.ENTITY_REMOVE_SCOREBOARD_TAG_METHOD == null || RefEntity.ENTITY_ADD_SCOREBOARD_TAG_METHOD == null) {
            return false;
        }
        try {
            if (((Set)RefEntity.ENTITY_GET_SCOREBOARD_TAGS_METHOD.invoke((Object)entity, new Object[0])).contains(scoreboardTag)) {
                RefEntity.ENTITY_REMOVE_SCOREBOARD_TAG_METHOD.invoke((Object)entity, scoreboardTag);
                return false;
            }
            RefEntity.ENTITY_ADD_SCOREBOARD_TAG_METHOD.invoke((Object)entity, scoreboardTag);
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public static Optional<Long> getPermissionValue(@NotNull Player player, @NotNull String permission) {
        for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
            String perm;
            if (!info.getValue() || !(perm = info.getPermission()).startsWith(permission)) continue;
            Optional<Long> value = Mapper.toLong(perm.substring(permission.length()));
            if (!value.isPresent()) {
                AnnoyingPlugin.log(Level.WARNING, "&cInvalid permission value for &4" + player.getName() + "&c: &4" + perm);
            }
            return value;
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<OfflinePlayer> getOfflinePlayer(@NotNull String name) {
        Player online = Bukkit.getPlayerExact((String)name);
        if (online != null) {
            return Optional.of(online);
        }
        String nameLower = name.toLowerCase();
        for (OfflinePlayer offline : Bukkit.getOfflinePlayers()) {
            String offlineName = offline.getName();
            if (offlineName == null || !offlineName.toLowerCase().equals(nameLower)) continue;
            return Optional.of(offline);
        }
        return Optional.empty();
    }

    @NotNull
    public static Set<String> getOnlinePlayerNames() {
        HashSet<String> set = new HashSet<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            set.add(player.getName());
        }
        return set;
    }

    @NotNull
    public static Set<String> getOfflinePlayerNames() {
        HashSet<String> set = new HashSet<String>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            String name;
            if (player.isOnline() || (name = player.getName()) == null) continue;
            set.add(name);
        }
        return set;
    }

    @NotNull
    public static Set<String> getAllPlayerNames() {
        HashSet<String> set = new HashSet<String>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            String name = player.getName();
            if (name == null) continue;
            set.add(name);
        }
        return set;
    }

    @NotNull
    public static Set<String> getWorldNames() {
        HashSet<String> set = new HashSet<String>();
        for (World world : Bukkit.getWorlds()) {
            set.add(world.getName());
        }
        return set;
    }

    private BukkitUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

