/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.listeners;

import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.CraftingTrigger;
import xyz.srnyx.limitedlives.config.Feature;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingListener;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.cooldown.AnnoyingCooldown;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.ItemData;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.DefaultReplaceType;
import xyz.srnyx.limitedlives.managers.player.PlayerManager;
import xyz.srnyx.limitedlives.managers.player.exception.MoreThanMaxLives;

public class PlayerInteractListener
extends AnnoyingListener {
    @NotNull
    private static final String COOLDOWN_KEY = "use_item";
    @NotNull
    private final LimitedLives plugin;

    public PlayerInteractListener(@NotNull LimitedLives plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public LimitedLives getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Action action = event.getAction();
        ItemStack item = event.getItem();
        if (action == Action.PHYSICAL || (action != Action.LEFT_CLICK_AIR && action != Action.LEFT_CLICK_BLOCK || !this.plugin.config.obtaining.crafting.triggers.contains((Object)CraftingTrigger.LEFT_CLICK)) && (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK || !this.plugin.config.obtaining.crafting.triggers.contains((Object)CraftingTrigger.RIGHT_CLICK)) || item == null || !new ItemData((AnnoyingPlugin)this.plugin, item).has("ll_item")) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.plugin.config.worldsBlacklist.isWorldEnabled(world, Feature.LIFE_USE)) {
            new AnnoyingMessage(this.plugin, "feature-disabled").replace("%feature%", (Object)Feature.LIFE_USE).replace("%world%", world.getName()).send((CommandSender)player);
            return;
        }
        AnnoyingCooldown cooldown = this.plugin.cooldownManager.getCooldownElseNew(player.getUniqueId(), COOLDOWN_KEY);
        if (cooldown.isOnCooldownStart(this.plugin.config.obtaining.crafting.cooldown.toMillis())) {
            new AnnoyingMessage(this.plugin, "eat.cooldown").replace("%remaining%", cooldown.getRemaining(), DefaultReplaceType.TIME).send((CommandSender)player);
            return;
        }
        try {
            item.setAmount(item.getAmount() - 1);
            new AnnoyingMessage(this.plugin, "eat.success").replace("%lives%", new PlayerManager(this.plugin, (OfflinePlayer)player).addLives(this.plugin.config.obtaining.crafting.amount)).send((CommandSender)player);
        }
        catch (MoreThanMaxLives e) {
            new AnnoyingMessage(this.plugin, "eat.max").replace("%max%", this.plugin.config.lives.max).send((CommandSender)player);
        }
    }
}

