/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.common.dimension_change;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_9787;
import no2.worldthreader.common.ServerWorldTicking;
import no2.worldthreader.common.dimension_change.TeleportedEntityInfo;
import no2.worldthreader.common.mixin_support.interfaces.EntityExtended;
import no2.worldthreader.common.mixin_support.interfaces.ServerWorldExtended;
import no2.worldthreader.common.thread.WorldThreadingManager;
import no2.worldthreader.init.ModGameRules;
import org.jetbrains.annotations.NotNull;

public class DimensionChangeHelper {
    public static boolean isDummy(class_5454 teleportTransition) {
        return teleportTransition.comp_2864() == null;
    }

    public static void expectDummy(class_5454 teleportTransition, String message) {
        if (!DimensionChangeHelper.isDummy(teleportTransition)) {
            throw new IllegalStateException("Worldthreader: " + message);
        }
    }

    public static boolean shouldConvertSelfToTeleportedEntityInfo(class_3218 destination) {
        return WorldThreadingManager.isWrongThreadForWorld(destination);
    }

    public static class_5454 getNonPassengerDummyTeleportTarget(class_3218 destination) {
        return new class_5454(destination, null, null, 0.0f, 0.0f, false, false, null, null);
    }

    public static void nonPassengerArriveInWorld(TeleportedEntityInfo teleportedEntityInfo, class_1297 oldEntityObject, class_3218 destination, class_3218 source) {
        class_5454 teleportTransition;
        TeleportedEntityInfo previous = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        if (teleportedEntityInfo.entityTransition() != null) {
            teleportTransition = teleportedEntityInfo.entityTransition();
        } else {
            ((ServerWorldExtended)destination).worldthreader$setArrivingEntityInfo(teleportedEntityInfo);
            class_9787 portalProcessor = Objects.requireNonNull(teleportedEntityInfo.portalProcessor());
            portalProcessor.method_60704(teleportedEntityInfo.portalProcessorPos());
            teleportTransition = portalProcessor.method_60701(source, oldEntityObject);
            ((ServerWorldExtended)destination).worldthreader$setArrivingEntityInfo(previous);
        }
        if (teleportTransition == null) {
            ((ServerWorldExtended)source).worldthreader$receiveFailedTeleport(teleportedEntityInfo);
            return;
        }
        class_1297 newEntity = DimensionChangeHelper.arriveIntoWorld(teleportedEntityInfo, oldEntityObject, destination, source, teleportTransition);
        if (ServerWorldTicking.isMainWorld(destination) && destination.method_64395().method_8355(ModGameRules.TELEPORTED_ENTITY_ADDITIONAL_TICK.getKey())) {
            newEntity.method_5773();
        }
    }

    @NotNull
    public static class_1297 arriveIntoWorld(TeleportedEntityInfo teleportedEntityInfo, class_1297 oldEntityObject, class_3218 destination, class_3218 source, class_5454 teleportTransition) {
        TeleportedEntityInfo previous = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        ((ServerWorldExtended)destination).worldthreader$setArrivingEntityInfo(teleportedEntityInfo);
        class_1297 newEntity = oldEntityObject instanceof class_3222 ? oldEntityObject.method_5731(teleportTransition) : oldEntityObject.method_64614(source, destination, teleportTransition);
        ((ServerWorldExtended)destination).worldthreader$setArrivingEntityInfo(previous);
        if (newEntity == null) {
            throw new IllegalStateException("Worldthreader: Entity could not be placed after crossing dimensions: " + String.valueOf(oldEntityObject));
        }
        ((EntityExtended)newEntity).worldthreader$onArrivedInServerWorld((class_5321<class_1937>)destination.method_27983(), (class_5321<class_1937>)source.method_27983());
        return newEntity;
    }

    public static class_1297 restoreEntityInWorld(TeleportedEntityInfo entityInfo) {
        List<TeleportedEntityInfo> passengerInfos = entityInfo.passengers();
        ArrayList<class_1297> passengers = new ArrayList<class_1297>(passengerInfos.size());
        for (TeleportedEntityInfo passenger : passengerInfos) {
            passengers.add(DimensionChangeHelper.restoreEntityInWorld(passenger));
        }
        class_1297 entity = entityInfo.oldEntityObject();
        ((EntityExtended)entity).worldthreader$restoreEntity(entityInfo);
        for (class_1297 passenger : passengers) {
            passenger.method_5873(entity, true);
        }
        return entity;
    }
}

