/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.mixin.dimension_change;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import no2.worldthreader.common.WorldThreaderTickPhase;
import no2.worldthreader.common.dimension_change.DimensionChangeHelper;
import no2.worldthreader.common.dimension_change.TeleportedEntityInfo;
import no2.worldthreader.common.mixin_support.interfaces.ServerWorldExtended;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3218.class})
public abstract class ServerLevelMixin
extends class_1937
implements ServerWorldExtended {
    @Unique
    private final Map<class_5321<class_1937>, ArrayList<TeleportedEntityInfo>> receivedEntities = new ConcurrentHashMap<class_5321<class_1937>, ArrayList<TeleportedEntityInfo>>();
    @Unique
    private final Set<TeleportedEntityInfo> failedTeleports = new ConcurrentHashMap().keySet(new Object());
    @Unique
    private TeleportedEntityInfo currentlyArrivingEntity;
    @Unique
    private TeleportedEntityInfo currentlyDepartingPassenger;
    @Unique
    private WorldThreaderTickPhase tickPhase = WorldThreaderTickPhase.NONE;

    protected ServerLevelMixin(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_5455 registryAccess, class_6880<class_2874> holder, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, bl, bl2, l, i);
    }

    @Shadow
    @NotNull
    public abstract MinecraftServer method_8503();

    @Override
    public void worldthreader$receiveTeleportedEntity(class_5321<class_1937> source, TeleportedEntityInfo teleportedEntityInfo) {
        ArrayList teleportedEntities = this.receivedEntities.computeIfAbsent(source, s -> new ArrayList());
        teleportedEntities.add(teleportedEntityInfo);
    }

    @Override
    public void worldthreader$finishReceivingTeleportedEntities() {
        Set levelKeys = this.method_8503().method_29435();
        for (class_5321 source : levelKeys) {
            ArrayList<TeleportedEntityInfo> teleportedEntityList = this.receivedEntities.remove(source);
            if (teleportedEntityList == null) continue;
            for (TeleportedEntityInfo teleportedEntity : teleportedEntityList) {
                try {
                    DimensionChangeHelper.nonPassengerArriveInWorld(teleportedEntity, teleportedEntity.oldEntityObject(), (class_3218)this, (class_3218)teleportedEntity.oldEntityObject().method_37908());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Worldthreader: Failed to receive teleported entity: " + String.valueOf(teleportedEntity) + " in dimension " + String.valueOf(this.method_27983()) + "!", e);
                }
            }
        }
    }

    @Override
    public void worldthreader$receiveFailedTeleport(TeleportedEntityInfo teleportedEntityInfo) {
        this.failedTeleports.add(teleportedEntityInfo);
    }

    @Override
    public void worldthreader$recoverFailedTeleports() {
        if (!this.failedTeleports.isEmpty()) {
            for (TeleportedEntityInfo teleportedEntity : this.failedTeleports) {
                DimensionChangeHelper.restoreEntityInWorld(teleportedEntity);
            }
            this.failedTeleports.clear();
        }
    }

    @Override
    public TeleportedEntityInfo worldthreader$arrivingEntityInfo() {
        return this.currentlyArrivingEntity;
    }

    @Override
    public void worldthreader$setArrivingEntityInfo(TeleportedEntityInfo teleportedEntityInfo) {
        this.currentlyArrivingEntity = teleportedEntityInfo;
    }

    @Override
    public TeleportedEntityInfo worldthreader$removeDepartingEntityInfo() {
        TeleportedEntityInfo entityInfo = this.currentlyDepartingPassenger;
        this.currentlyDepartingPassenger = null;
        return entityInfo;
    }

    @Override
    public void worldthreader$putDepartingPassengerEntityInfo(TeleportedEntityInfo teleportedEntityInfo) {
        if (this.currentlyDepartingPassenger != null) {
            throw new IllegalStateException("Worldthreader: Another entity is already departing from this level!");
        }
        this.currentlyDepartingPassenger = teleportedEntityInfo;
    }

    @Override
    public WorldThreaderTickPhase worldthreader$getTickPhase() {
        return this.tickPhase;
    }

    @Override
    public void worldthreader$setTickPhase(WorldThreaderTickPhase tickPhase) {
        this.tickPhase = tickPhase;
    }
}

