/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.mixin.dimension_change.arrival;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_5454;
import net.minecraft.class_8589;
import no2.worldthreader.common.dimension_change.DimensionChangeHelper;
import no2.worldthreader.common.thread.WorldThreadingManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin {
    @Shadow
    public abstract class_3218 method_51469();

    @ModifyExpressionValue(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isRemoved()Z")})
    private boolean isRemovedAndNotArrivalPhase(boolean original, @Local(argsOnly=true) class_5454 teleportTransition, @Share(value="isArrival") LocalBooleanRef isMultithreadedPassengerArrival, @Share(value="isRecovery") LocalBooleanRef isRecovery) {
        if (DimensionChangeHelper.isDummy(teleportTransition)) {
            return original;
        }
        if (!WorldThreadingManager.isMultithreadingAndCorrectThreadForWorld(teleportTransition.comp_2820())) {
            return original;
        }
        if (WorldThreadingManager.isRecoveringTeleports(teleportTransition.comp_2820())) {
            if (this.method_51469() != teleportTransition.comp_2820()) {
                throw new IllegalStateException("Worldthreader: Failed teleport recovery in wrong dimension!");
            }
            isRecovery.set(true);
            return false;
        }
        if (WorldThreadingManager.isPlacingReceivedTeleports(teleportTransition.comp_2820())) {
            if (this.method_51469() == teleportTransition.comp_2820()) {
                throw new IllegalStateException("Worldthreader: Cross dimensional arrival split must be cross-dimensional!");
            }
            isMultithreadedPassengerArrival.set(true);
            return false;
        }
        return original;
    }

    @ModifyExpressionValue(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/portal/TeleportTransition;missingRespawnBlock()Z")})
    private boolean isMissingRespawnBlockAndNotArrivalPhase(boolean original, @Share(value="isArrival") LocalBooleanRef isMultithreadedPassengerArrival, @Share(value="isRecovery") LocalBooleanRef isRecovery) {
        return original && !isMultithreadedPassengerArrival.get() && !isRecovery.get();
    }

    @WrapOperation(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;createCommonSpawnInfo(Lnet/minecraft/server/level/ServerLevel;)Lnet/minecraft/network/protocol/game/CommonPlayerSpawnInfo;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension:Z", opcode=181), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;unsetRemoved()V"))})
    private class_8589 createCommonSpawnInfoIfDeparture(class_3222 instance, class_3218 serverLevel, Operation<class_8589> original, @Share(value="isArrival") LocalBooleanRef isMultithreadedPassengerArrival) {
        if (isMultithreadedPassengerArrival.get()) {
            return null;
        }
        return (class_8589)original.call(new Object[]{instance, serverLevel});
    }

    @WrapWithCondition(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension:Z", opcode=181), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;unsetRemoved()V"))})
    private boolean sendIfDeparture(class_3244 instance, class_2596<?> packet, @Share(value="isArrival") LocalBooleanRef isMultithreadedPassengerArrival) {
        return !isMultithreadedPassengerArrival.get();
    }

    @WrapWithCondition(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;sendPlayerPermissionLevel(Lnet/minecraft/server/level/ServerPlayer;)V")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension:Z", opcode=181), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;unsetRemoved()V"))})
    private boolean sendPlayerPermissionLevelIfDeparture(class_3324 instance, class_3222 serverPlayer, @Share(value="isArrival") LocalBooleanRef isMultithreadedPassengerArrival) {
        return !isMultithreadedPassengerArrival.get();
    }

    @WrapWithCondition(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;removePlayerImmediately(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/Entity$RemovalReason;)V")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension:Z", opcode=181), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;unsetRemoved()V"))})
    private boolean removePlayerImmediatelyIfDeparture(class_3218 instance, class_3222 serverPlayer, class_1297.class_5529 removalReason, @Share(value="isArrival") LocalBooleanRef isMultithreadedPassengerArrival, @Share(value="isRecovery") LocalBooleanRef isRecovery) {
        return !isMultithreadedPassengerArrival.get() && !isRecovery.get();
    }
}

