/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.mixin.exclusive_world_access;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import no2.worldthreader.common.mixin_support.interfaces.MinecraftServerExtended;
import no2.worldthreader.common.thread.WorldThreadingManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements MinecraftServerExtended {
    @Shadow
    @Final
    private Map<class_5321<class_1937>, class_3218> field_4589;

    @Override
    public class_3218 worldthreader$getLevelUnsynchronized(class_5321<class_1937> key) {
        return this.field_4589.get(key);
    }

    @Unique
    private void acquireSingleThreadedWorldAccess() {
        if (this.worldthreader$isTickMultithreaded()) {
            WorldThreadingManager worldThreadingManager = Objects.requireNonNull(this.worldthreader$getThreadingManager());
            worldThreadingManager.waitForExclusiveWorldAccess();
        }
    }

    @Inject(method={"getAllLevels"}, at={@At(value="HEAD")})
    private void avoidParallelWorldAccess1(CallbackInfoReturnable<Iterable<class_3218>> cir) {
        this.acquireSingleThreadedWorldAccess();
    }

    @Inject(method={"getLevel(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/server/level/ServerLevel;"}, at={@At(value="HEAD")})
    private void avoidParallelWorldAccess2(class_5321<class_1937> key, CallbackInfoReturnable<@Nullable class_3218> cir) {
        if (this.worldthreader$isTickMultithreaded()) {
            WorldThreadingManager worldThreadingManager = Objects.requireNonNull(this.worldthreader$getThreadingManager());
            if (!worldThreadingManager.isWorldThread(Thread.currentThread())) {
                return;
            }
            if (!worldThreadingManager.isWorldThreadOf(key)) {
                this.acquireSingleThreadedWorldAccess();
            }
        }
    }

    @Inject(method={"overworld()Lnet/minecraft/server/level/ServerLevel;"}, at={@At(value="HEAD")})
    private void avoidParallelWorldAccess3(CallbackInfoReturnable<class_3218> cir) {
        this.acquireSingleThreadedWorldAccess();
    }

    @Inject(method={"getPackRepository", "getCommandStorage", "getCustomBossEvents", "getFunctions"}, at={@At(value="HEAD")})
    private void avoidParallelServerDataAccess(CallbackInfoReturnable<class_3218> cir) {
        this.acquireSingleThreadedWorldAccess();
    }
}

