/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.common;

import java.util.function.BooleanSupplier;
import net.minecraft.class_10209;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_27;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;
import no2.worldthreader.common.WorldThreaderTickPhase;
import no2.worldthreader.common.mixin_support.interfaces.ServerWorldExtended;
import no2.worldthreader.common.thread.ThreadHelper;
import no2.worldthreader.common.thread.ThreadLocals;
import no2.worldthreader.common.thread.ThreadOwnedObject;
import no2.worldthreader.common.thread.WorldThreadingManager;

public class ServerWorldTicking {
    public static boolean isMainWorld(class_3218 world) {
        return !(world.method_8401() instanceof class_27);
    }

    public static void runWorldThread(MinecraftServer server, WorldThreadingManager worldThreadingManager, class_3218 serverWorld, ThreadOwnedObject[] threadOwnedObjects) {
        Thread currentThread = Thread.currentThread();
        ThreadLocals.WORLD_THREAD_MINECRAFT_SERVER_ACCESS.set(server);
        boolean continueMultithreading = true;
        while (continueMultithreading) {
            if (worldThreadingManager.tickBarrier() < 0) {
                continueMultithreading = false;
                continue;
            }
            Thread mainThread = ((ThreadOwnedObject)serverWorld).worldthreader$getOwningThread();
            ThreadHelper.swapOnMultithreadTickStart(mainThread, currentThread, threadOwnedObjects);
            ServerWorldTicking.tickThreaded(server, worldThreadingManager, serverWorld);
            ThreadHelper.swapOnMultithreadTickEnd(mainThread, currentThread, threadOwnedObjects);
            if (worldThreadingManager.tickBarrier() >= 0) continue;
            continueMultithreading = false;
        }
        ThreadLocals.WORLD_THREAD_MINECRAFT_SERVER_ACCESS.remove();
    }

    public static void tickThreaded(MinecraftServer server, WorldThreadingManager worldThreadingManager, class_3218 serverLevel) {
        BooleanSupplier shouldKeepTicking = worldThreadingManager::shouldKeepTickingThreaded;
        String crashReason = "Exception in server world thread";
        try {
            class_3695 profilerFiller = class_10209.method_64146();
            profilerFiller.method_15400(() -> String.valueOf(serverLevel) + " " + String.valueOf(serverLevel.method_27983().method_29177()));
            if (server.method_3780() % 20 == 0) {
                profilerFiller.method_15396("timeSync");
                server.method_49750(serverLevel);
                profilerFiller.method_15407();
            }
            profilerFiller.method_15396("tick");
            crashReason = "Exception ticking world";
            worldThreadingManager.withinTickBarrier();
            ((ServerWorldExtended)serverLevel).worldthreader$setTickPhase(WorldThreaderTickPhase.WORLD_TICK);
            serverLevel.method_18765(shouldKeepTicking);
            crashReason = "Exception receiving entities from other worlds";
            worldThreadingManager.withinTickBarrier();
            ((ServerWorldExtended)serverLevel).worldthreader$setTickPhase(WorldThreaderTickPhase.RECEIVE_TELEPORTS);
            ServerWorldTicking.finishTeleportsToWorld(serverLevel);
            crashReason = "Exception restoring entities that could not be teleported to another world";
            worldThreadingManager.withinTickBarrier();
            ((ServerWorldExtended)serverLevel).worldthreader$setTickPhase(WorldThreaderTickPhase.RECOVER_FAILED_TELEPORTS);
            ServerWorldTicking.recoverFailedTeleports(serverLevel);
            crashReason = "Exception in server world thread";
            worldThreadingManager.withinTickBarrier();
            ((ServerWorldExtended)serverLevel).worldthreader$setTickPhase(WorldThreaderTickPhase.NONE);
            profilerFiller.method_15407();
            profilerFiller.method_15407();
        }
        catch (Throwable throwable) {
            ServerWorldTicking.delegateCrash(throwable, crashReason, serverLevel, worldThreadingManager);
        }
    }

    private static void delegateCrash(Throwable throwable, String title, class_3218 serverLevel, WorldThreadingManager worldThreadingManager) {
        String serverLevelOwner = ((ThreadOwnedObject)serverLevel).worldthreader$getOwningThread().getName();
        String chunkCacheOwner = ((ThreadOwnedObject)serverLevel.method_14178()).worldthreader$getOwningThread().getName();
        worldThreadingManager.tryGiveAwayExclusiveWorldAccess();
        class_128 crashReport = class_128.method_560((Throwable)throwable, (String)title);
        serverLevel.method_8538(crashReport);
        class_129 worldthreaderCrashInfo = crashReport.method_562("WorldThreader");
        worldthreaderCrashInfo.method_578("Crashing thread", (Object)Thread.currentThread().getName());
        worldthreaderCrashInfo.method_578("Level owner", (Object)serverLevelOwner);
        worldthreaderCrashInfo.method_578("ChunkCache owner", (Object)chunkCacheOwner);
        worldThreadingManager.handleCrash(crashReport);
    }

    public static void finishTeleportsToWorld(class_3218 world) {
        ((ServerWorldExtended)world).worldthreader$finishReceivingTeleportedEntities();
    }

    public static void recoverFailedTeleports(class_3218 world) {
        ((ServerWorldExtended)world).worldthreader$recoverFailedTeleports();
    }
}

