/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.common.thread;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Phaser;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import no2.worldthreader.WorldThreaderMod;
import no2.worldthreader.common.ServerWorldTicking;
import no2.worldthreader.common.WorldThreaderTickPhase;
import no2.worldthreader.common.mixin_support.interfaces.MinecraftServerExtended;
import no2.worldthreader.common.mixin_support.interfaces.ServerWorldExtended;
import no2.worldthreader.common.thread.ThreadHelper;
import no2.worldthreader.common.thread.ThreadOwnedObject;

public class WorldThreadingManager {
    public static boolean DEBUG = false;
    private final MinecraftServer server;
    private final Phaser tickBarrier;
    private final Phaser withinTickBarrier;
    private final Reference2ReferenceLinkedOpenHashMap<Thread, class_5321<class_1937>> worldThreads;
    private final Reference2ReferenceOpenHashMap<Thread, ThreadOwnedObject[]> worldThreads2OwnedObjects;
    private final AtomicInteger threadsRequestingExclusiveWorldAccess = new AtomicInteger();
    private final Semaphore exclusiveWorldAccessLock = new Semaphore(1);
    private final AtomicReference<Thread> threadWithExclusiveWorldAccess = new AtomicReference<Object>(null);
    private boolean isMultiThreadedPhase = false;
    private class_128 crashReport;
    public final Object2ReferenceOpenHashMap<UUID, PlayerInfo> lastPlayerInfos = new Object2ReferenceOpenHashMap();

    public WorldThreadingManager(MinecraftServer server) {
        WorldThreaderMod.initializeBeforeThreading(server);
        this.server = server;
        this.tickBarrier = new Phaser();
        this.withinTickBarrier = new Phaser();
        this.tickBarrier.register();
        this.worldThreads = new Reference2ReferenceLinkedOpenHashMap();
        this.worldThreads2OwnedObjects = new Reference2ReferenceOpenHashMap();
        Iterable worlds = this.server.method_3738();
        for (class_3218 world : worlds) {
            ThreadOwnedObject[] worldThreadOwned = new ThreadOwnedObject[]{(ThreadOwnedObject)world, (ThreadOwnedObject)world.method_14178()};
            Thread worldThread = new Thread(() -> ServerWorldTicking.runWorldThread(server, this, world, worldThreadOwned));
            ThreadHelper.setWorldThreadName(worldThread, world);
            this.worldThreads2OwnedObjects.put((Object)worldThread, (Object)worldThreadOwned);
            this.worldThreads.put((Object)worldThread, (Object)world.method_27983());
            this.tickBarrier.register();
            this.withinTickBarrier.register();
            worldThread.start();
        }
    }

    public static void ensureExclusiveScoreboardAccess(MinecraftServer server) {
        WorldThreadingManager worldThreadingManager = ((MinecraftServerExtended)server).worldthreader$getThreadingManager();
        if (worldThreadingManager != null && worldThreadingManager.isMultiThreadedPhase()) {
            worldThreadingManager.waitForExclusiveWorldAccess(false);
        }
    }

    public static void crashIfNoExclusiveScoreboardAccess(MinecraftServer server) {
        if (!WorldThreadingManager.hasExclusiveScoreboardAccess(server)) {
            throw new IllegalStateException("Worldthreader: Scoreboard operation requires exclusive scoreboard access!");
        }
    }

    public static boolean hasExclusiveScoreboardAccess(MinecraftServer server) {
        WorldThreadingManager worldThreadingManager = ((MinecraftServerExtended)server).worldthreader$getThreadingManager();
        if (worldThreadingManager != null && worldThreadingManager.isMultiThreadedPhase()) {
            Thread currentThread = Thread.currentThread();
            Thread thread = worldThreadingManager.threadWithExclusiveWorldAccess.get();
            return thread == currentThread;
        }
        return true;
    }

    public static boolean isPlacingReceivedTeleports(class_3218 newLevel) {
        return WorldThreadingManager.isMultithreadingAndCorrectThreadForWorld(newLevel) && ((ServerWorldExtended)newLevel).worldthreader$getTickPhase() == WorldThreaderTickPhase.RECEIVE_TELEPORTS;
    }

    public static boolean isRecoveringTeleports(class_3218 newLevel) {
        return WorldThreadingManager.isMultithreadingAndCorrectThreadForWorld(newLevel) && ((ServerWorldExtended)newLevel).worldthreader$getTickPhase() == WorldThreaderTickPhase.RECOVER_FAILED_TELEPORTS;
    }

    public static WorldThreadingManager get(class_3218 serverLevel) {
        return ((MinecraftServerExtended)serverLevel.method_8503()).worldthreader$getThreadingManager();
    }

    public boolean isMultiThreadedPhase() {
        return this.isMultiThreadedPhase;
    }

    public void setMultiThreadedPhase(boolean value) {
        this.isMultiThreadedPhase = value;
    }

    public boolean isWorldThread(Thread thread) {
        return this.worldThreads.containsKey((Object)thread);
    }

    public boolean isWorldThreadOf(class_5321<class_1937> dimension) {
        return dimension.equals(this.worldThreads.get((Object)Thread.currentThread()));
    }

    public boolean isWorldThreadOf(class_3218 serverLevel) {
        return this.isWorldThreadOf((class_5321<class_1937>)serverLevel.method_27983());
    }

    public static boolean isAccessibleForOtherThread(class_3218 world) {
        return Thread.currentThread() != ((ThreadOwnedObject)world).worldthreader$getOwningThread();
    }

    public static boolean hasToAcquireExclusiveAccessBeforeAccessing(class_3218 world) {
        return ((MinecraftServerExtended)world.method_8503()).worldthreader$isTickMultithreaded() && WorldThreadingManager.isAccessibleForOtherThread(world);
    }

    public static boolean isWrongThreadForWorld(class_3218 world) {
        WorldThreadingManager worldThreadingManager = ((MinecraftServerExtended)world.method_8503()).worldthreader$getThreadingManager();
        return worldThreadingManager != null && worldThreadingManager.isMultiThreadedPhase() && !worldThreadingManager.isWorldThreadOf(world);
    }

    public static boolean isMultithreadingAndCorrectThreadForWorld(class_3218 world) {
        WorldThreadingManager worldThreadingManager = ((MinecraftServerExtended)world.method_8503()).worldthreader$getThreadingManager();
        return worldThreadingManager != null && worldThreadingManager.isMultiThreadedPhase() && worldThreadingManager.isWorldThreadOf(world);
    }

    public int tickBarrier() {
        return this.barrier(this.tickBarrier);
    }

    public void withinTickBarrier() {
        this.barrier(this.withinTickBarrier);
    }

    public boolean shouldKeepTickingThreaded() {
        return ((MinecraftServerExtended)this.server).worldthreader$shouldKeepTickingThreaded();
    }

    public void terminate() {
        this.tickBarrier.forceTermination();
        this.withinTickBarrier.forceTermination();
    }

    private int barrier(Phaser phaser) {
        boolean mustUnparkWaitingThread = this.tryGiveAwayExclusiveWorldAccess();
        int phase = phaser.getPhase();
        phaser.arrive();
        if (mustUnparkWaitingThread) {
            this.unparkThreadWaitingOnExclusiveWorldAccess();
        }
        return phaser.awaitAdvance(phase);
    }

    public boolean hasExclusiveWorldAccess() {
        return this.threadWithExclusiveWorldAccess.get() == Thread.currentThread();
    }

    public void waitForExclusiveWorldAccess(boolean noDebug) {
        Thread currentThread = Thread.currentThread();
        Thread thread = this.threadWithExclusiveWorldAccess.get();
        if (!this.isWorldThread(currentThread)) {
            WorldThreaderMod.LOGGER.error("Thread {} is requesting exclusive world access. However, only world threads may request exclusive access during the world ticking!", (Object)currentThread);
            throw new IllegalStateException("Only world threads may request exclusive access during world ticking!");
        }
        if (DEBUG) {
            if (thread != currentThread) {
                WorldThreaderMod.LOGGER.info("Thread {} is requesting exclusive world access", (Object)currentThread);
                WorldThreaderMod.LOGGER.info("This slows down the game, but at least doesn't break it.");
                WorldThreaderMod.LOGGER.info("Current thread with exclusive world access: {}", (Object)thread);
            } else {
                WorldThreaderMod.LOGGER.info("Thread {} is using the exclusive world access again", (Object)currentThread);
            }
            WorldThreaderMod.LOGGER.info("Thread {} stacktrace for information:", (Object)currentThread);
            new Exception().printStackTrace();
        }
        if (thread == currentThread) {
            return;
        }
        this.threadsRequestingExclusiveWorldAccess.getAndIncrement();
        thread = this.threadWithExclusiveWorldAccess.get();
        if (thread != null) {
            LockSupport.unpark(thread);
        }
        this.exclusiveWorldAccessLock.acquireUninterruptibly();
        this.threadWithExclusiveWorldAccess.set(currentThread);
        while (true) {
            boolean allOtherThreadsWaiting;
            if (allOtherThreadsWaiting = this.areAllThreadsInBarrierOrAccessRequest()) {
                this.setOwnershipOfAllThreadOwnedObjects(currentThread);
                if (DEBUG) {
                    WorldThreaderMod.LOGGER.info("Thread {} has acquired exclusive world access", (Object)currentThread.getName());
                    WorldThreaderMod.LOGGER.info("Total threads requesting exclusive world access: {}", (Object)this.threadsRequestingExclusiveWorldAccess.get());
                }
                return;
            }
            LockSupport.park(this);
        }
    }

    private void setOwnershipOfAllThreadOwnedObjects(Thread currentThread) {
        ObjectIterator objectIterator = this.worldThreads2OwnedObjects.values().iterator();
        while (objectIterator.hasNext()) {
            ThreadOwnedObject[] threadOwnedObjects;
            for (ThreadOwnedObject threadOwnedObject : threadOwnedObjects = (ThreadOwnedObject[])objectIterator.next()) {
                if (threadOwnedObject == null) continue;
                threadOwnedObject.worldthreader$setOwningThread(currentThread);
            }
        }
    }

    private void resetOwnershipOfAllThreadOwnedObjects() {
        this.worldThreads2OwnedObjects.forEach((key, threadOwnedObjects) -> {
            for (ThreadOwnedObject threadOwnedObject : threadOwnedObjects) {
                if (threadOwnedObject == null) continue;
                threadOwnedObject.worldthreader$setOwningThread((Thread)key);
            }
        });
    }

    private boolean areAllThreadsInBarrierOrAccessRequest() {
        int totalThreads = this.tickBarrier.getRegisteredParties();
        int arrivedParties = this.withinTickBarrier.getRegisteredParties() - this.withinTickBarrier.getUnarrivedParties();
        arrivedParties += this.tickBarrier.getRegisteredParties() - this.tickBarrier.getUnarrivedParties();
        if ((arrivedParties += this.threadsRequestingExclusiveWorldAccess.get()) > totalThreads) {
            throw new IllegalStateException("More arrived parties than expected!");
        }
        return totalThreads == arrivedParties;
    }

    public boolean tryGiveAwayExclusiveWorldAccess() {
        Thread thread = this.threadWithExclusiveWorldAccess.get();
        if (thread != null) {
            if (thread == Thread.currentThread()) {
                this.resetOwnershipOfAllThreadOwnedObjects();
                int andDecrement = this.threadsRequestingExclusiveWorldAccess.getAndDecrement();
                if (DEBUG) {
                    WorldThreaderMod.LOGGER.info("Thread {} releasing exclusive world access", (Object)thread.getName());
                    WorldThreaderMod.LOGGER.info("Other threads waiting for exclusive world access: {}", (Object)(andDecrement - 1));
                }
                this.threadWithExclusiveWorldAccess.set(null);
                this.exclusiveWorldAccessLock.release();
            } else {
                return true;
            }
        }
        return false;
    }

    public void unparkThreadWaitingOnExclusiveWorldAccess() {
        Thread thread = this.threadWithExclusiveWorldAccess.get();
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public synchronized void handleCrash(class_128 crashReport) {
        if (this.crashReport == null) {
            this.crashReport = crashReport;
            this.tickBarrier.forceTermination();
        } else {
            this.crashReport.method_562("Crashing while already crashing").method_578("Crash Report", (Object)crashReport);
        }
    }

    public void throwCrashIfPresent() {
        if (this.crashReport != null) {
            int threadsToJoin = this.worldThreads.size();
            for (int i = 0; i < 2 && threadsToJoin > 0; ++i) {
                for (Thread thread : this.worldThreads.keySet()) {
                    try {
                        thread.join(1000L);
                        --threadsToJoin;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.withinTickBarrier.forceTermination();
            }
            throw new class_148(this.crashReport);
        }
    }

    public void updateThreadsafePlayerInfos(Collection<class_3222> players) {
        this.lastPlayerInfos.clear();
        for (class_3222 player : players) {
            this.lastPlayerInfos.put((Object)player.method_5667(), (Object)new PlayerInfo(player));
        }
    }

    public boolean wasAlive(UUID uuid) {
        PlayerInfo playerInfo = (PlayerInfo)this.lastPlayerInfos.get((Object)uuid);
        return playerInfo == null || !playerInfo.dead() && !playerInfo.removed();
    }

    public boolean wasDead(UUID uuid) {
        PlayerInfo playerInfo = (PlayerInfo)this.lastPlayerInfos.get((Object)uuid);
        return playerInfo != null && playerInfo.dead();
    }

    public boolean wonGame(UUID uuid) {
        PlayerInfo playerInfo = (PlayerInfo)this.lastPlayerInfos.get((Object)uuid);
        return playerInfo != null && playerInfo.wonGame();
    }

    public record PlayerInfo(boolean dead, boolean removed, boolean wonGame) {
        public PlayerInfo(class_3222 player) {
            this(player.method_29504(), player.method_31481(), player.field_13989);
        }
    }
}

