/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.mixin.fixes.leash;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Either;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9817;
import no2.worldthreader.common.thread.WorldThreadingManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9817.class})
public interface LeashableMixin {
    @Inject(method={"tickLeash"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Leashable$LeashData;delayedLeashInfo:Lcom/mojang/datafixers/util/Either;")})
    private static <E extends class_1297> void handleTeleportedPlayer(class_3218 serverLevel, E entity, CallbackInfo ci, @Local class_9817.class_9818 leashData) {
        WorldThreadingManager worldThreadingManager;
        class_3222 serverPlayer;
        class_1297 class_12972;
        if (leashData.field_52218 == null && (class_12972 = leashData.field_52217) instanceof class_3222 && (serverPlayer = (class_3222)class_12972).method_35049() == class_1297.class_5529.field_27002 && (worldThreadingManager = WorldThreadingManager.get(serverPlayer.method_51469())) != null && worldThreadingManager.isMultiThreadedPhase() && worldThreadingManager.wasAlive(serverPlayer.method_5667())) {
            leashData.field_52218 = Either.left((Object)serverPlayer.method_5667());
        }
    }

    @Redirect(method={"tickLeash(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;canInteractWithLevel()Z", ordinal=1))
    private static <E extends class_1297> boolean getThreadedIsAlive(class_1297 instance, @Local class_9817.class_9818 leashData) {
        class_3222 serverPlayer;
        if (instance instanceof class_3222 && (serverPlayer = (class_3222)instance).method_35049() == class_1297.class_5529.field_27002) {
            WorldThreadingManager worldThreadingManager = WorldThreadingManager.get(serverPlayer.method_51469());
            if (worldThreadingManager != null && worldThreadingManager.isMultiThreadedPhase()) {
                return worldThreadingManager.wasAlive(serverPlayer.method_5667());
            }
            return !serverPlayer.method_29504();
        }
        return instance.method_5805();
    }

    @ModifyConstant(method={"restoreLeashFromSave"}, constant={@Constant(intValue=100)})
    private static int skipDestroyingLeashIfTeleportedPlayer(int constant, @Local(argsOnly=true) class_9817.class_9818 leashData) {
        WorldThreadingManager worldThreadingManager;
        class_3222 serverPlayer;
        class_1297 class_12972;
        if (leashData.field_52218 != null && (class_12972 = leashData.field_52217) instanceof class_3222 && (serverPlayer = (class_3222)class_12972).method_35049() == class_1297.class_5529.field_27002 && (worldThreadingManager = WorldThreadingManager.get(serverPlayer.method_51469())) != null && worldThreadingManager.wasAlive(serverPlayer.method_5667())) {
            return Integer.MAX_VALUE;
        }
        return constant;
    }
}

