/*
 * Decompiled with CFR 0.152.
 */
package no2.worldthreader.mixin.dimension_change.arrival;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import no2.worldthreader.common.dimension_change.DimensionChangeHelper;
import no2.worldthreader.common.dimension_change.TeleportedEntityInfo;
import no2.worldthreader.common.mixin_support.interfaces.EntityExtended;
import no2.worldthreader.common.mixin_support.interfaces.ServerWorldExtended;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements EntityExtended {
    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    protected abstract class_5454 method_64613(class_5454 var1, class_1297 var2);

    @WrapOperation(method={"teleportCrossDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getPassengers()Ljava/util/List;")})
    private List<class_1297> getPassengerOrEmpty(class_1297 entity, Operation<List<class_1297>> original, @Local(argsOnly=true, ordinal=1) class_3218 destination) {
        TeleportedEntityInfo currentlyArrivingEntity = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        if (currentlyArrivingEntity != null) {
            return List.of();
        }
        return (List)original.call(new Object[]{entity});
    }

    @WrapOperation(method={"teleportCrossDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I", remap=false)})
    private int getSize(List<class_1297> instance, Operation<Integer> original, @Local(argsOnly=true, ordinal=1) class_3218 destination) {
        TeleportedEntityInfo currentlyArrivingEntity = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        if (currentlyArrivingEntity != null) {
            return currentlyArrivingEntity.passengers().size();
        }
        return (Integer)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"teleportCrossDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;ejectPassengers()V")})
    private void ejectPassengers(class_1297 instance, Operation<Void> original, @Local(argsOnly=true, ordinal=1) class_3218 destination) {
        TeleportedEntityInfo currentlyArrivingEntity = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        if (currentlyArrivingEntity == null) {
            original.call(new Object[]{instance});
        }
    }

    @Inject(method={"teleportCrossDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V")})
    private void placePassengers(class_3218 serverLevel, class_3218 serverLevel2, class_5454 teleportTransition, CallbackInfoReturnable<class_1297> cir, @Local(argsOnly=true, ordinal=1) class_3218 destination, @Local(ordinal=1) List<class_1297> passengersAdded) {
        TeleportedEntityInfo currentlyArrivingEntity = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        if (currentlyArrivingEntity != null) {
            if (this != currentlyArrivingEntity.oldEntityObject()) {
                throw new IllegalStateException("Worldthreader: Expected arriving entity to be the current entity!");
            }
            List<TeleportedEntityInfo> passengers = currentlyArrivingEntity.passengers();
            for (TeleportedEntityInfo passengerEntityInfo : passengers) {
                class_5454 passengerTeleportTransition = passengerEntityInfo.entityTransition() != null ? passengerEntityInfo.entityTransition() : this.method_64613(teleportTransition, passengerEntityInfo.oldEntityObject());
                class_1297 newEntity = DimensionChangeHelper.arriveIntoWorld(passengerEntityInfo, passengerEntityInfo.oldEntityObject(), destination, (class_3218)this.method_37908(), passengerTeleportTransition);
                passengersAdded.add(newEntity);
            }
        }
    }

    @WrapOperation(method={"restoreFrom(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;saveWithoutId(Lnet/minecraft/world/level/storage/ValueOutput;)V")})
    private void restoreFromNbt0(class_1297 instance, class_11372 valueOutput, Operation<Void> original) {
        class_3218 destination;
        TeleportedEntityInfo currentlyArrivingEntity;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (currentlyArrivingEntity = ((ServerWorldExtended)(destination = (class_3218)class_19372)).worldthreader$arrivingEntityInfo()) != null) {
            return;
        }
        original.call(new Object[]{instance, valueOutput});
    }

    @WrapOperation(method={"restoreFrom(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/TagValueOutput;buildResult()Lnet/minecraft/nbt/CompoundTag;")})
    private class_2487 restoreFromNbt1(class_11362 tagValueOutput, Operation<class_2487> original) {
        class_3218 destination;
        TeleportedEntityInfo currentlyArrivingEntity;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (currentlyArrivingEntity = ((ServerWorldExtended)(destination = (class_3218)class_19372)).worldthreader$arrivingEntityInfo()) != null) {
            return Objects.requireNonNull(currentlyArrivingEntity.nbtCompound()).method_10543(tagValueOutput.method_71475());
        }
        return (class_2487)original.call(new Object[]{tagValueOutput});
    }

    @WrapOperation(method={"teleportCrossDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;removeAfterChangingDimensions()V")})
    private void removeOldEntity(class_1297 instance, Operation<Void> original, @Local(argsOnly=true, ordinal=1) class_3218 destination) {
        TeleportedEntityInfo currentlyArrivingEntity = ((ServerWorldExtended)destination).worldthreader$arrivingEntityInfo();
        if (currentlyArrivingEntity == null) {
            original.call(new Object[]{instance});
        }
    }
}

