/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.menu.provider;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.litetex.capes.Capes;
import net.litetex.capes.menu.TickBoxWidget;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.DefaultMinecraftCapeProvider;
import net.litetex.capes.provider.antifeature.AntiFeature;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8666;

public class ProviderListWidget
extends class_4280<ProviderListEntry> {
    private static final int ITEM_HEIGHT = 21;
    private final class_437 parent;

    public ProviderListWidget(class_310 client, int width, int height, class_437 parent) {
        super(client, width, height, 0, 21);
        this.parent = parent;
        this.load();
    }

    private void load() {
        Capes capes = Capes.instance();
        ArrayList<String> activeProviderIds = new ArrayList<String>(capes.config().getActiveProviderIds());
        this.method_25314(Stream.concat(capes.getAllProviders().values().stream().filter(Capes.EXCLUDE_DEFAULT_MINECRAFT_CP).sorted(Comparator.comparing(cp -> {
            int index = activeProviderIds.indexOf(cp.id());
            return index != -1 ? index : Integer.MAX_VALUE;
        })).map(cp -> this.createEntry((CapeProvider)cp, activeProviderIds.contains(cp.id()))), Stream.of(this.createEntry(DefaultMinecraftCapeProvider.INSTANCE, capes.isUseDefaultProvider()))).toList());
        List children = this.method_25396();
        ((ProviderListEntry)((Object)children.getFirst())).upVisible(false);
        ((ProviderListEntry)((Object)children.get(children.size() - 2))).downVisible(false);
        ProviderListEntry last = (ProviderListEntry)((Object)children.getLast());
        last.upVisible(false);
        last.downVisible(false);
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
        this.method_73367();
    }

    private ProviderListEntry createEntry(CapeProvider capeProvider, boolean active) {
        return new ProviderListEntry(capeProvider, active, this.parent, (self, a) -> this.save(), this::onPositionChanged);
    }

    private void save() {
        Capes capes = Capes.instance();
        List<CapeProvider> capeProviders = this.method_25396().stream().filter(ProviderListEntry::isActive).map(ProviderListEntry::capeProvider).toList();
        List<String> idsWithoutDefault = capeProviders.stream().filter(Capes.EXCLUDE_DEFAULT_MINECRAFT_CP).map(CapeProvider::id).toList();
        capes.config().setActiveProviderIds(idsWithoutDefault);
        capes.config().setUseDefaultProvider(idsWithoutDefault.size() != capeProviders.size());
        capes.saveConfigAndMarkRefresh();
    }

    private void onPositionChanged(ProviderListEntry entry, boolean up) {
        int lastIndex;
        ProviderListEntry lowerEntry;
        List children = this.method_25396();
        int selfIndex = children.indexOf((Object)entry);
        int otherIndex = selfIndex + (up ? -1 : 1);
        ProviderListEntry other = (ProviderListEntry)((Object)children.get(otherIndex));
        this.method_73368(selfIndex, otherIndex);
        ProviderListEntry higherEntry = up ? entry : other;
        ProviderListEntry providerListEntry = lowerEntry = up ? other : entry;
        if (selfIndex == 0 || otherIndex == 0) {
            higherEntry.upVisible(false);
            higherEntry.downVisible(true);
            lowerEntry.upVisible(true);
        }
        if (selfIndex == (lastIndex = children.size() - 2) || otherIndex == lastIndex) {
            higherEntry.downVisible(true);
            lowerEntry.upVisible(true);
            lowerEntry.downVisible(false);
        }
        this.save();
    }

    public int method_25322() {
        return this.method_25368() - 4;
    }

    static class ProviderListEntry
    extends class_4280.class_4281<ProviderListEntry> {
        private static final int BTN_EDIT_CAPE_WIDTH = 96;
        private static final class_2960 MOVE_UP_HIGHLIGHTED_TEXTURE = class_2960.method_60654((String)"textures/gui/sprites/transferable_list/move_up_highlighted.png");
        private static final class_2960 MOVE_UP_TEXTURE = class_2960.method_60654((String)"textures/gui/sprites/transferable_list/move_up.png");
        private static final class_2960 MOVE_DOWN_HIGHLIGHTED_TEXTURE = class_2960.method_60654((String)"textures/gui/sprites/transferable_list/move_down_highlighted.png");
        private static final class_2960 MOVE_DOWN_TEXTURE = class_2960.method_60654((String)"textures/gui/sprites/transferable_list/move_down.png");
        private static final class_8666 WARNING_BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"social_interactions/report_button"), class_2960.method_60656((String)"social_interactions/report_button_disabled"), class_2960.method_60656((String)"social_interactions/report_button_highlighted"));
        private final CapeProvider capeProvider;
        private final Supplier<class_5250> nameTextSupplier;
        private boolean isNameHovering;
        private final Runnable onTxtClick;
        private final TickBoxWidget chbxActive;
        private final class_7842 txtName;
        private final class_344 icoWarn;
        private final class_4185 btnEditCape;
        private final UpDownIconWidget icoMoveUp;
        private final UpDownIconWidget icoMoveDown;

        public ProviderListEntry(CapeProvider capeProvider, boolean activated, class_437 parentScreen, BiConsumer<ProviderListEntry, Boolean> onActiveChanged, BiConsumer<ProviderListEntry, Boolean> onPositionChange) {
            this.capeProvider = capeProvider;
            class_310 client = class_310.method_1551();
            this.chbxActive = new TickBoxWidget(13, activated, false, (w, ticked) -> onActiveChanged.accept(this, (Boolean)ticked));
            String homepageUrl = capeProvider.homepageUrl();
            boolean hasHomePageUrl = homepageUrl != null;
            this.nameTextSupplier = () -> ProviderListEntry.formatMutableTextIf(class_2561.method_43470((String)this.capeProvider.name()), hasHomePageUrl, class_124.field_1078);
            BiFunction<class_2561, class_327, class_7842> widgetFunc = hasHomePageUrl ? ClickableTextWidget::new : class_7842::new;
            this.txtName = widgetFunc.apply((class_2561)this.nameTextSupplier.get(), class_310.method_1551().field_1772);
            this.txtName.field_22763 = hasHomePageUrl;
            this.onTxtClick = hasHomePageUrl ? () -> client.method_1507((class_437)new class_407(open -> {
                if (open) {
                    class_156.method_668().method_670(homepageUrl);
                }
                client.method_1507(parentScreen);
            }, homepageUrl, true)) : null;
            List<AntiFeature> antiFeatures = capeProvider.antiFeatures();
            class_344 class_3442 = this.icoWarn = !antiFeatures.isEmpty() ? new class_344(17, 17, WARNING_BUTTON_TEXTURES, btn -> {}, class_5244.field_39003) : null;
            if (this.icoWarn != null) {
                this.icoWarn.method_47400(class_7919.method_47407((class_2561)((class_2561)antiFeatures.stream().map(AntiFeature::message).map(t -> class_2561.method_43470((String)"- ").method_10852((class_2561)t)).reduce((t1, t2) -> t1.method_27693("\n").method_10852((class_2561)t2)).orElseThrow())));
            }
            this.btnEditCape = capeProvider.hasChangeCapeUrl() ? class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit cape"), btn -> {
                String link = capeProvider.changeCapeUrl(client);
                client.method_1507((class_437)new class_407(open -> {
                    if (open) {
                        class_156.method_668().method_670(link);
                    }
                    client.method_1507(parentScreen);
                }, link, true));
            }).method_46437(96, 17).method_46431() : null;
            this.icoMoveUp = new UpDownIconWidget(15, 10, MOVE_UP_TEXTURE, MOVE_UP_HIGHLIGHTED_TEXTURE, 32, 32, (class_2561)class_2561.method_43471((String)"gui.up"), -16, -4, 14, 4, () -> onPositionChange.accept(this, true));
            this.icoMoveDown = new UpDownIconWidget(15, 10, MOVE_DOWN_TEXTURE, MOVE_DOWN_HIGHLIGHTED_TEXTURE, 32, 32, (class_2561)class_2561.method_43471((String)"gui.down"), -16, -20, 14, 20, () -> onPositionChange.accept(this, false));
        }

        public CapeProvider capeProvider() {
            return this.capeProvider;
        }

        public boolean isActive() {
            return this.chbxActive.isTicked();
        }

        public void upVisible(boolean visible) {
            this.icoMoveUp.field_22764 = visible;
        }

        public void downVisible(boolean visible) {
            this.icoMoveDown.field_22764 = visible;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean isOverName;
            int x = this.method_73380();
            int y = this.method_73382();
            int entryWidth = this.method_73387();
            this.chbxActive.method_48229(x, y + (21 - this.chbxActive.method_25364() - 4) / 2);
            this.chbxActive.method_25394(context, mouseX, mouseY, tickDelta);
            if (this.onTxtClick != null && this.isNameHovering != (isOverName = this.txtName.method_49606())) {
                this.txtName.method_25355((class_2561)ProviderListEntry.formatMutableTextIf(this.nameTextSupplier.get(), isOverName, class_124.field_1073));
                this.isNameHovering = isOverName;
            }
            this.txtName.method_48229(x + this.chbxActive.method_25368() + 4, y + (21 - this.txtName.method_25364()) / 2 - 1);
            this.txtName.method_25394(context, mouseX, mouseY, tickDelta);
            if (this.icoWarn != null) {
                this.icoWarn.method_48229(x + entryWidth - this.icoWarn.method_25368() - 96 - this.icoMoveUp.method_25368() - 12, y + (21 - this.icoWarn.method_25364()) / 2 - 2);
                this.icoWarn.method_25394(context, mouseX, mouseY, tickDelta);
            }
            if (this.btnEditCape != null) {
                this.btnEditCape.method_48229(x + entryWidth - 96 - this.icoMoveUp.method_25368() - 8, y);
                this.btnEditCape.method_25394(context, mouseX, mouseY, tickDelta);
            }
            this.icoMoveUp.method_48229(x + entryWidth - this.icoMoveUp.method_25368() - 4, y);
            this.icoMoveUp.method_25394(context, mouseX, mouseY, tickDelta);
            this.icoMoveDown.method_48229(x + entryWidth - this.icoMoveDown.method_25368() - 4, y + 10);
            this.icoMoveDown.method_25394(context, mouseX, mouseY, tickDelta);
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            double mouseY;
            double mouseX = click.comp_4798();
            if (this.chbxActive.method_25405(mouseX, mouseY = click.comp_4799())) {
                return this.chbxActive.method_25402(click, doubled);
            }
            if (this.onTxtClick != null && this.txtName.method_25405(mouseX, mouseY)) {
                this.onTxtClick.run();
                return true;
            }
            if (this.btnEditCape != null && this.btnEditCape.method_25405(mouseX, mouseY)) {
                return this.btnEditCape.method_25402(click, doubled);
            }
            if (this.icoMoveUp.method_25405(mouseX, mouseY)) {
                return this.icoMoveUp.method_25402(click, doubled);
            }
            if (this.icoMoveDown.method_25405(mouseX, mouseY)) {
                return this.icoMoveDown.method_25402(click, doubled);
            }
            return true;
        }

        private static class_5250 formatMutableTextIf(class_5250 text, boolean condition, class_124 formatting) {
            return condition ? text.method_27692(formatting) : text;
        }

        public boolean method_25404(class_11908 input) {
            int keyCode = input.method_74228();
            if (32 == keyCode || 257 == keyCode) {
                this.chbxActive.toggle();
                return true;
            }
            if (1 == input.comp_4797()) {
                if (265 == keyCode && this.icoMoveUp.field_22764) {
                    this.icoMoveUp.click();
                    return true;
                }
                if (264 == keyCode && this.icoMoveDown.field_22764) {
                    this.icoMoveDown.click();
                    return true;
                }
            }
            return super.method_25404(input);
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.capeProvider().name());
        }
    }

    static class ClickableTextWidget
    extends class_7842 {
        public ClickableTextWidget(class_2561 message, class_327 textRenderer) {
            super(message, textRenderer);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            super.method_48579(context, mouseX, mouseY, deltaTicks);
            if (this.method_25405(mouseX, mouseY)) {
                context.method_74037(class_11876.field_62455);
            }
        }
    }

    static class UpDownIconWidget
    extends class_339 {
        private final class_2960 texture;
        private final class_2960 hoverTexture;
        private final int textureWidth;
        private final int textureHeight;
        private final int drawOffsetX;
        private final int drawOffsetY;
        private final int drawAdditionalWidth;
        private final int drawAdditionalHeight;
        private final Runnable onClick;

        public UpDownIconWidget(int width, int height, class_2960 texture, class_2960 hoverTexture, int textureWidth, int textureHeight, class_2561 text, int drawOffsetX, int drawOffsetY, int drawAdditionalWidth, int drawAdditionalHeight, Runnable onClick) {
            super(0, 0, width, height, text);
            this.texture = texture;
            this.hoverTexture = hoverTexture;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.drawOffsetX = drawOffsetX;
            this.drawOffsetY = drawOffsetY;
            this.drawAdditionalWidth = drawAdditionalWidth;
            this.drawAdditionalHeight = drawAdditionalHeight;
            this.onClick = onClick;
        }

        public void method_25348(class_11909 click, boolean bl) {
            super.method_25348(click, bl);
            this.click();
        }

        public void click() {
            this.onClick.run();
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25290(class_10799.field_56883, this.method_25405(mouseX, mouseY) ? this.hoverTexture : this.texture, this.method_46426() + this.drawOffsetX, this.method_46427() + this.drawOffsetY, 0.0f, 0.0f, this.method_25368() + this.drawAdditionalWidth, this.method_25364() + this.drawAdditionalHeight, this.textureWidth, this.textureHeight);
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

