/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes;

import com.mojang.authlib.GameProfile;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.litetex.capes.config.Config;
import net.litetex.capes.config.ModProviderHandling;
import net.litetex.capes.handler.PlayerCapeHandler;
import net.litetex.capes.handler.PlayerCapeHandlerManager;
import net.litetex.capes.handler.ProfileTextureLoadThrottler;
import net.litetex.capes.handler.textures.TextureResolver;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.CustomProvider;
import net.litetex.capes.provider.DefaultMinecraftCapeProvider;
import net.litetex.capes.provider.ModMetadataProvider;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8685;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Capes {
    private static final Logger LOG = LoggerFactory.getLogger(Capes.class);
    public static final String MOD_ID = "cape-provider";
    public static final class_2960 DEFAULT_ELYTRA_IDENTIFIER = class_2960.method_60654((String)"textures/entity/equipment/wings/elytra.png");
    public static final Predicate<CapeProvider> EXCLUDE_DEFAULT_MINECRAFT_CP = cp -> DefaultMinecraftCapeProvider.INSTANCE != cp;
    private static Capes instance;
    private final Config config;
    private final Consumer<Config> saveConfigFunc;
    private final Map<String, CapeProvider> allProviders;
    private final Map<String, TextureResolver> allTextureResolvers;
    private final boolean validateProfile;
    private final Duration loadThrottleSuppressDuration;
    private final Map<CapeProvider, Set<Integer>> blockedProviderCapeHashes;
    private final int playerCacheSize;
    private final boolean useRealPlayerOnlineValidation;
    private final PlayerCapeHandlerManager playerCapeHandlerManager;
    private final ProfileTextureLoadThrottler profileTextureLoadThrottler;
    private boolean shouldRefresh;

    public static Capes instance() {
        return instance;
    }

    public static void setInstance(Capes instance) {
        Capes.instance = instance;
    }

    public Capes(Config config, Consumer<Config> saveConfigFunc, Map<String, CapeProvider> allProviders, Map<String, TextureResolver> allTextureResolvers) {
        this.config = config;
        this.saveConfigFunc = saveConfigFunc;
        this.allProviders = allProviders;
        this.allTextureResolvers = allTextureResolvers;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Providers: {}", allProviders.keySet());
            LOG.debug("Texture-Resolvers: {}", allTextureResolvers.keySet());
        }
        this.validateProfile = !Boolean.FALSE.equals(this.config().isValidateProfile());
        LOG.debug("validateProfile: {}", (Object)this.validateProfile);
        this.loadThrottleSuppressDuration = Optional.ofNullable(this.config().getLoadThrottleSuppressSec()).map(Duration::ofSeconds).orElse(Duration.ofMinutes(3L));
        LOG.debug("loadThrottleSuppressDuration: {}", (Object)this.loadThrottleSuppressDuration);
        this.blockedProviderCapeHashes = Optional.ofNullable(this.config().getBlockedProviderCapeHashes()).map(map -> map.entrySet().stream().filter(e -> allProviders.containsKey(e.getKey())).collect(Collectors.toMap(e -> (CapeProvider)allProviders.get(e.getKey()), Map.Entry::getValue))).orElseGet(Map::of);
        LOG.debug("blockedProviderCapeHashes: {}x", (Object)this.blockedProviderCapeHashes.size());
        Integer configPlayerCacheSize = this.config.getPlayerCacheSize();
        this.playerCacheSize = configPlayerCacheSize != null ? Math.clamp((long)configPlayerCacheSize.intValue(), 1, 100000) : 1000;
        LOG.debug("playerCacheSize: {}", (Object)this.playerCacheSize);
        this.useRealPlayerOnlineValidation = Boolean.TRUE.equals(config.getUseRealPlayerOnlineValidation());
        LOG.debug("useRealPlayerOnlineValidation: {}", (Object)this.useRealPlayerOnlineValidation);
        this.playerCapeHandlerManager = new PlayerCapeHandlerManager(this);
        this.profileTextureLoadThrottler = new ProfileTextureLoadThrottler(this.playerCapeHandlerManager, this.playerCacheSize());
        long startMs = System.currentTimeMillis();
        this.postProcessModProviders();
        LOG.debug("Post processing mod providers took {}ms", (Object)(System.currentTimeMillis() - startMs));
    }

    protected void postProcessModProviders() {
        ModProviderHandling modProviderHandling = this.config().getModProviderHandling();
        if (modProviderHandling.activateByDefault()) {
            Set providerIdsLoadedByMods = this.getAllProviders().values().stream().filter(ModMetadataProvider.class::isInstance).map(ModMetadataProvider.class::cast).map(CustomProvider::id).collect(Collectors.toCollection(LinkedHashSet::new));
            Instant nullPlaceholder = Instant.MAX;
            Instant now = Instant.now();
            Instant removeOutdated = now.minus(Duration.ofDays(7L));
            Map<String, Instant> knownProviderIdsFirstTimeMissing = Optional.ofNullable(this.config().getKnownModProviderIdsFirstTimeMissing()).map(Map::entrySet).stream().flatMap(Collection::stream).filter(e -> nullPlaceholder.equals(e.getValue()) || ((Instant)e.getValue()).isAfter(removeOutdated)).collect(Collectors.toMap(Map.Entry::getKey, e -> nullPlaceholder.equals(e.getValue()) ? now : (Instant)e.getValue()));
            Set activeProviderIds = Objects.requireNonNullElseGet(this.config().getActiveProviderIds(), LinkedHashSet::new);
            providerIdsLoadedByMods.stream().filter(id -> !knownProviderIdsFirstTimeMissing.containsKey(id)).forEach(activeProviderIds::add);
            this.config().setActiveProviderIds(activeProviderIds);
            providerIdsLoadedByMods.forEach(id -> knownProviderIdsFirstTimeMissing.put((String)id, nullPlaceholder));
            this.config().setKnownModProviderIdsFirstTimeMissing(knownProviderIdsFirstTimeMissing);
            this.saveConfig();
            return;
        }
        if (this.config().getKnownModProviderIdsFirstTimeMissing() != null) {
            this.config().setKnownModProviderIdsFirstTimeMissing(null);
            this.saveConfig();
        }
    }

    public void saveConfig() {
        this.saveConfigFunc.accept(this.config);
    }

    public void saveConfigAndMarkRefresh() {
        this.saveConfig();
        this.shouldRefresh = true;
    }

    public void refreshIfMarked() {
        if (this.shouldRefresh) {
            this.refresh();
            this.shouldRefresh = false;
        }
    }

    protected void refresh() {
        this.profileTextureLoadThrottler.clearCache();
        this.playerCapeHandlerManager.clearCache();
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler != null) {
            networkHandler.method_2880().forEach(e -> this.profileTextureLoadThrottler.loadIfRequired(e.method_2966()));
        }
    }

    public Config config() {
        return this.config;
    }

    public Map<String, CapeProvider> getAllProviders() {
        return this.allProviders;
    }

    public Map<String, TextureResolver> getAllTextureResolvers() {
        return this.allTextureResolvers;
    }

    public Optional<CapeProvider> getCapeProviderForSelf() {
        return Optional.ofNullable(this.config.getCurrentPreviewProviderId()).map(this.allProviders::get);
    }

    public List<CapeProvider> activeCapeProviders() {
        return this.config.getActiveProviderIds().stream().map(this.allProviders::get).filter(EXCLUDE_DEFAULT_MINECRAFT_CP).filter(Objects::nonNull).toList();
    }

    public boolean isUseDefaultProvider() {
        return this.config().isUseDefaultProvider();
    }

    public boolean validateProfile() {
        return this.validateProfile;
    }

    public Duration loadThrottleSuppressDuration() {
        return this.loadThrottleSuppressDuration;
    }

    public Map<CapeProvider, Set<Integer>> blockedProviderCapeHashes() {
        return this.blockedProviderCapeHashes;
    }

    public int playerCacheSize() {
        return this.playerCacheSize;
    }

    public boolean useRealPlayerOnlineValidation() {
        return this.useRealPlayerOnlineValidation;
    }

    public ProfileTextureLoadThrottler textureLoadThrottler() {
        return this.profileTextureLoadThrottler;
    }

    public PlayerCapeHandlerManager playerCapeHandlerManager() {
        return this.playerCapeHandlerManager;
    }

    public boolean overwriteSkinTextures(GameProfile profile, Supplier<class_8685> oldTexureSupplier, Consumer<class_8685> applyOverwrittenTextures) {
        class_2960 capeTexture;
        PlayerCapeHandler handler = this.playerCapeHandlerManager().getProfile(profile);
        if (handler != null && (capeTexture = handler.getCape()) != null) {
            class_8685 oldTextures = oldTexureSupplier.get();
            class_2960 elytraTexture = handler.hasElytraTexture() && this.config().isEnableElytraTexture() ? capeTexture : DEFAULT_ELYTRA_IDENTIFIER;
            applyOverwrittenTextures.accept(new class_8685(oldTextures.comp_1626(), oldTextures.comp_1911(), capeTexture, elytraTexture, oldTextures.comp_1629(), oldTextures.comp_1630()));
            return true;
        }
        if (!this.isUseDefaultProvider()) {
            class_8685 oldTextures = oldTexureSupplier.get();
            applyOverwrittenTextures.accept(new class_8685(oldTextures.comp_1626(), oldTextures.comp_1911(), null, null, oldTextures.comp_1629(), oldTextures.comp_1630()));
            return true;
        }
        return false;
    }
}

