/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.handler;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.litetex.capes.Capes;
import net.litetex.capes.config.AnimatedCapesHandling;
import net.litetex.capes.handler.AnimatedNativeImageContainer;
import net.litetex.capes.handler.IdentifierProvider;
import net.litetex.capes.handler.textures.DefaultTextureResolver;
import net.litetex.capes.handler.textures.TextureResolver;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerCapeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerCapeHandler.class);
    private final Capes capes;
    private final GameProfile profile;
    private Optional<IdentifierProvider> optIdentifierProvider = Optional.empty();
    private boolean hasElytraTexture = true;

    public PlayerCapeHandler(Capes capes, GameProfile profile) {
        this.capes = capes;
        this.profile = profile;
    }

    public Optional<IdentifierProvider> capeIdentifierProvider() {
        return this.optIdentifierProvider;
    }

    public class_2960 getCape() {
        IdentifierProvider identifierProvider = this.optIdentifierProvider.orElse(null);
        if (identifierProvider != null) {
            return identifierProvider.identifier();
        }
        return null;
    }

    public void resetCape() {
        this.optIdentifierProvider = Optional.empty();
        this.hasElytraTexture = true;
    }

    public boolean trySetCape(CapeProvider capeProvider) {
        String profileApiUrl = capeProvider.getBaseUrl(this.profile);
        if (profileApiUrl == null) {
            return false;
        }
        try {
            ResolvedTextureInfo.UrlTextureInfo urlInfo;
            HttpClient.Builder clientBuilder = this.createBuilder();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(profileApiUrl)).timeout(Duration.ofSeconds(10L)).header("User-Agent", "CP");
            ResolvedTextureInfo resolvedTextureInfo = capeProvider.resolveTexture(clientBuilder, requestBuilder, this.profile);
            if (resolvedTextureInfo == null) {
                return false;
            }
            byte[] imageBytes = resolvedTextureInfo.imageBytes();
            String textureUrlForLog = profileApiUrl;
            if (resolvedTextureInfo instanceof ResolvedTextureInfo.UrlTextureInfo && (urlInfo = (ResolvedTextureInfo.UrlTextureInfo)resolvedTextureInfo).textureURL() != null) {
                textureUrlForLog = urlInfo.textureURL();
                try {
                    HttpClient imageClient = clientBuilder.build();
                    HttpRequest imageRequest = HttpRequest.newBuilder(URI.create(urlInfo.textureURL())).timeout(Duration.ofSeconds(10L)).header("User-Agent", "CP").build();
                    HttpResponse<byte[]> imageResponse = imageClient.send(imageRequest, HttpResponse.BodyHandlers.ofByteArray());
                    if (imageResponse.statusCode() / 100 != 2) {
                        LOG.warn("Failed to fetch cape image[url='{}',profileId='{}',statusCode='{}']", new Object[]{urlInfo.textureURL(), this.profile.getId(), imageResponse.statusCode()});
                        return false;
                    }
                    imageBytes = imageResponse.body();
                }
                catch (Exception e) {
                    LOG.warn("Failed to fetch cape image[url='{}',profileId='{}']", new Object[]{urlInfo.textureURL(), this.profile.getId(), e});
                    return false;
                }
            }
            if (imageBytes == null) {
                return false;
            }
            if (this.isCapeBlocked(capeProvider, imageBytes)) {
                return false;
            }
            TextureResolver textureResolver = this.capes.getAllTextureResolvers().getOrDefault(resolvedTextureInfo.textureResolverId(), DefaultTextureResolver.INSTANCE);
            AnimatedCapesHandling animatedCapesHandling = this.animatedCapesHandling();
            if (textureResolver.animated() && animatedCapesHandling == AnimatedCapesHandling.OFF) {
                return false;
            }
            this.optIdentifierProvider = this.registerTexturesAndGetProvider(this.determineTexturesToRegister(textureResolver, imageBytes, animatedCapesHandling == AnimatedCapesHandling.FROZEN, textureUrlForLog));
            return this.optIdentifierProvider.isPresent();
        }
        catch (InterruptedException iex) {
            LOG.warn("Got interrupted[url='{}',profileId='{}']", new Object[]{profileApiUrl, this.profile.getId(), iex});
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            LOG.warn("Failed to process texture[url='{}',profileId='{}']", new Object[]{profileApiUrl, this.profile.getId(), ex});
        }
        this.resetCape();
        return false;
    }

    private HttpClient.Builder createBuilder() {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L));
        final Proxy proxy = class_310.method_1551().method_1487();
        if (proxy != null) {
            clientBuilder.proxy(new ProxySelector(this){

                @Override
                public List<Proxy> select(URI uri) {
                    return List.of(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
        }
        return clientBuilder;
    }

    private boolean isCapeBlocked(CapeProvider provider, byte[] imageBytes) {
        Set<Integer> blockedCapeHashes = this.capes.blockedProviderCapeHashes().get(provider);
        if (blockedCapeHashes == null) {
            return false;
        }
        return blockedCapeHashes.contains(Arrays.hashCode(imageBytes));
    }

    private List<TextureToRegister> determineTexturesToRegister(TextureResolver textureResolver, byte[] imageData, boolean freezeAnimation, String url) throws IOException {
        TextureResolver.ResolvedTextureData resolved = textureResolver.resolve(imageData, freezeAnimation);
        boolean bl = this.hasElytraTexture = !Boolean.FALSE.equals(resolved.hasElytra());
        if (resolved instanceof TextureResolver.DefaultResolvedTextureData) {
            TextureResolver.DefaultResolvedTextureData defaultResolvedTextureData = (TextureResolver.DefaultResolvedTextureData)resolved;
            return List.of(new TextureToRegister(PlayerCapeHandler.identifier(this.uuid().toString()), defaultResolvedTextureData.texture()));
        }
        if (resolved instanceof TextureResolver.AnimatedResolvedTextureData) {
            TextureResolver.AnimatedResolvedTextureData animatedResolvedTextureData = (TextureResolver.AnimatedResolvedTextureData)resolved;
            List<AnimatedNativeImageContainer> textures = animatedResolvedTextureData.textures();
            Stream animatedTextureStream = textures.stream();
            if (textures.isEmpty()) {
                LOG.warn("Received animated texture with no frames[url='{}',profileId='{}']", (Object)url, (Object)this.profile.getId());
                return List.of();
            }
            if (freezeAnimation) {
                animatedTextureStream = animatedTextureStream.limit(1L);
            }
            AtomicInteger counter = new AtomicInteger(0);
            return animatedTextureStream.map(c -> new TextureToRegister(PlayerCapeHandler.identifier(String.valueOf(this.uuid()) + (String)(!freezeAnimation ? "/" + counter.getAndIncrement() : "")), c.image(), c.delayMs())).toList();
        }
        throw new IllegalStateException("Unexpected ResolvedTextureData: " + resolved.getClass().getSimpleName());
    }

    private Optional<IdentifierProvider> registerTexturesAndGetProvider(List<TextureToRegister> texturesToRegister) {
        if (texturesToRegister.isEmpty()) {
            return Optional.empty();
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        CompletableFuture.runAsync(() -> texturesToRegister.forEach(t -> textureManager.method_4616(t.identifier(), (class_1044)new class_1043(() -> ((class_2960)t.identifier()).toString(), t.image()))), (Executor)class_310.method_1551()).exceptionally(ex -> {
            LOG.warn("Failed to register textures", ex);
            return null;
        });
        return Optional.of(texturesToRegister.size() == 1 ? new DefaultIdentifierProvider(texturesToRegister.getFirst().identifier()) : new AnimatedIdentifierProvider(texturesToRegister));
    }

    private AnimatedCapesHandling animatedCapesHandling() {
        return this.capes.config().getAnimatedCapesHandling();
    }

    static class_2960 identifier(String id) {
        return class_2960.method_60655((String)"cape-provider", (String)id);
    }

    public UUID uuid() {
        return this.profile.getId();
    }

    public boolean hasElytraTexture() {
        return this.hasElytraTexture;
    }

    record TextureToRegister(class_2960 identifier, class_1011 image, int delayMs) {
        public TextureToRegister(class_2960 identifier, class_1011 image) {
            this(identifier, image, 100);
        }
    }

    record DefaultIdentifierProvider(class_2960 identifier) implements IdentifierProvider
    {
        @Override
        public boolean dynamicIdentifier() {
            return false;
        }
    }

    static class AnimatedIdentifierProvider
    implements IdentifierProvider {
        private final List<IdentifierContainer> identifiers;
        private int lastFrameIndex;
        private long nextFrameTime;

        public AnimatedIdentifierProvider(Collection<TextureToRegister> identifiers) {
            this.identifiers = identifiers.stream().map(t -> new IdentifierContainer(t.identifier(), Math.clamp((long)t.delayMs(), 1, 60000))).toList();
        }

        @Override
        public class_2960 identifier() {
            long time = System.currentTimeMillis();
            if (time > this.nextFrameTime) {
                int thisFrameIndex;
                this.lastFrameIndex = thisFrameIndex = (this.lastFrameIndex + 1) % this.identifiers.size();
                IdentifierContainer ic = this.identifiers.get(thisFrameIndex);
                this.nextFrameTime = time + (long)ic.delay();
                return ic.identifier();
            }
            return this.identifiers.get(this.lastFrameIndex).identifier();
        }

        @Override
        public boolean dynamicIdentifier() {
            return true;
        }

        record IdentifierContainer(class_2960 identifier, int delay) {
        }
    }
}

