/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.handler;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import net.litetex.capes.Capes;
import net.litetex.capes.handler.PlayerCapeHandlerManager;
import net.litetex.capes.util.collections.MaxSizedHashMap;

public class ProfileTextureLoadThrottler {
    private final Map<UUID, Instant> loadThrottle;
    private final PlayerCapeHandlerManager playerCapeHandlerManager;

    public ProfileTextureLoadThrottler(PlayerCapeHandlerManager playerCapeHandlerManager, int playerCacheSize) {
        this.playerCapeHandlerManager = playerCapeHandlerManager;
        this.loadThrottle = Collections.synchronizedMap(new MaxSizedHashMap(playerCacheSize));
    }

    public void loadIfRequired(GameProfile profile) {
        UUID id = profile.getId();
        Instant lastLoadTime = this.loadThrottle.get(id);
        Instant now = Instant.now();
        if (lastLoadTime == null || lastLoadTime.isBefore(now.minus(Capes.instance().loadThrottleSuppressDuration()))) {
            this.loadThrottle.put(id, now);
            this.playerCapeHandlerManager.onLoadTexture(profile);
        }
    }

    public void clearCache() {
        this.loadThrottle.clear();
    }
}

