/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.handler;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import net.litetex.capes.util.collections.MaxSizedHashMap;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealPlayerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RealPlayerValidator.class);
    private final Map<UUID, Boolean> cache;
    private final boolean useOnlineValidation;

    public RealPlayerValidator(int playerCacheSize, boolean useOnlineValidation) {
        this.cache = Collections.synchronizedMap(new MaxSizedHashMap(playerCacheSize));
        this.useOnlineValidation = useOnlineValidation;
    }

    public boolean isReal(GameProfile profile) {
        return this.cache.computeIfAbsent(profile.getId(), ignored -> this.checkReal(profile));
    }

    private boolean checkReal(GameProfile profile) {
        ValidityState validityState = this.determineIfInvalid(class_310.method_1551(), profile);
        LOG.debug("Determined that {}/{} is {}a real player: {}", new Object[]{profile.getName(), profile.getId(), validityState.isValid() ? "" : "NOT ", validityState.name()});
        return validityState.isValid();
    }

    private ValidityState determineIfInvalid(class_310 client, GameProfile profile) {
        if (profile.getId().equals(client.method_1548().method_44717())) {
            return ValidityState.SELF;
        }
        if (profile.getId().version() != 4) {
            return ValidityState.UUID_INCORRECT_VERSION;
        }
        if (!this.isValidName(profile.getName())) {
            return ValidityState.INVALID_NAME;
        }
        if (this.useOnlineValidation && !this.isValidSessionProfile(client, profile.getId())) {
            return ValidityState.ONLINE_VALIDATION_FAIL;
        }
        return ValidityState.DEFAULT_OK;
    }

    private boolean isValidName(String playerName) {
        int length = playerName.length();
        if (length < 3 || length > 16) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = playerName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    private boolean isValidSessionProfile(class_310 client, UUID id) {
        try {
            return client.method_1495().fetchProfile(id, false) != null;
        }
        catch (Exception ex) {
            LOG.warn("Failed to validate player using online services", (Throwable)ex);
            return true;
        }
    }

    static enum ValidityState {
        SELF(true),
        UUID_INCORRECT_VERSION(false),
        INVALID_NAME(false),
        ONLINE_VALIDATION_FAIL(false),
        DEFAULT_OK(true);

        private final boolean valid;

        private ValidityState(boolean valid) {
            this.valid = valid;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

