/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.menu.preview;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.litetex.capes.Capes;
import net.litetex.capes.handler.IdentifierProvider;
import net.litetex.capes.handler.PlayerCapeHandler;
import net.litetex.capes.handler.PlayerCapeHandlerManager;
import net.litetex.capes.menu.MainMenuScreen;
import net.litetex.capes.menu.preview.render.PlayerDisplayGuiPayload;
import net.litetex.capes.menu.preview.render.PlayerDisplayWidget;
import net.litetex.capes.provider.CapeProvider;
import net.minecraft.class_1068;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_591;
import net.minecraft.class_8685;

public class PreviewMenuScreen
extends MainMenuScreen {
    private final PlayerDisplayWidget playerWidget;
    private final ViewModel viewModel = new ViewModel();

    public PreviewMenuScreen(class_437 parent, class_315 gameOptions) {
        super(parent, gameOptions);
        PlayerLimbAnimator playerLimbAnimator = new PlayerLimbAnimator(60);
        this.playerWidget = new PlayerDisplayWidget(120, 120, class_310.method_1551().method_31974(), this.viewModel::getPayload, models -> playerLimbAnimator.animate(models.player(), 1.0f));
        this.playerWidget.field_46006 = 185.0f;
    }

    @Override
    protected void initSelfMangedDrawableChilds() {
        super.initSelfMangedDrawableChilds();
        int buttonW = 200;
        this.addSelfManagedDrawableChild(class_4185.method_46430((class_2561)this.textForCurrentlyDisplayedCapeProvider(), button -> {
            Capes capes = Capes.instance();
            ArrayList<CapeProvider> providers = new ArrayList<CapeProvider>(capes.getAllProviders().values());
            int nextIndex = capes.getCapeProviderForSelf().map(providers::indexOf).orElse(-1) + 1;
            capes.config().setCurrentPreviewProviderId(nextIndex > providers.size() - 1 ? null : ((CapeProvider)providers.get(nextIndex % providers.size())).id());
            capes.saveConfig();
            this.viewModel.providerChanged();
            button.method_25355(this.textForCurrentlyDisplayedCapeProvider());
        }).method_46433(this.field_22789 / 2 - buttonW / 2, 60).method_46437(buttonW, 20).method_46431());
        this.playerWidget.method_53533(Math.clamp((long)(this.field_22790 - 120), 25, 180));
        this.playerWidget.method_48229(this.field_22789 / 2 - this.playerWidget.method_25368() / 2, 82);
        buttonW = 100;
        int playerWidgetCenterY = this.playerWidget.method_46427() + this.playerWidget.method_25364() / 2;
        this.addSelfManagedDrawableChild(class_4185.method_46430((class_2561)class_2561.method_43471((String)"options.cape-provider.toggle_elytra"), b -> this.viewModel.toggleShowElytra()).method_46433(this.field_22789 / 4 - buttonW / 2, playerWidgetCenterY - 23).method_46437(buttonW, 20).method_46431());
        this.addSelfManagedDrawableChild(class_4185.method_46430((class_2561)class_2561.method_43471((String)"options.cape-provider.toggle_player"), b -> this.viewModel.toggleShowBody()).method_46433(this.field_22789 / 4 - buttonW / 2, playerWidgetCenterY + 2).method_46437(buttonW, 20).method_46431());
        this.addSelfManagedDrawableChild(this.playerWidget);
    }

    private class_2561 textForCurrentlyDisplayedCapeProvider() {
        return (class_2561)Capes.instance().getCapeProviderForSelf().map(CapeProvider::name).map(class_2561::method_43470).orElseGet(() -> class_2561.method_43471((String)"options.cape-provider.activated_providers"));
    }

    static class ViewModel {
        private static final Supplier<class_2960> DEFAULT_ELYTRA_SUPPLIER = () -> Capes.DEFAULT_ELYTRA_IDENTIFIER;
        private final GameProfile gameProfile;
        private class_8685 skin;
        private boolean slim;
        private List<CapeProvider> capeProviders;
        private Supplier<class_2960> capeTextureSupplier;
        private Supplier<class_2960> elytraTextureSupplier = DEFAULT_ELYTRA_SUPPLIER;
        private boolean showBody = true;
        private boolean showElytra;
        private PlayerDisplayGuiPayload payload;

        public ViewModel() {
            this.gameProfile = class_310.method_1551().method_53462();
            this.skin = class_1068.method_52854((GameProfile)this.gameProfile);
            this.refreshActiveCapeProviders();
            this.rebuildPayload();
            class_310.method_1551().method_1582().method_52863(this.gameProfile).thenAcceptAsync(optSkinTextures -> optSkinTextures.ifPresent(skinTextures -> {
                this.skin = skinTextures;
                this.slim = class_8685.class_7920.field_41122.equals((Object)this.skin.comp_1629());
                this.updateCapeAndElytraTexture();
            }));
        }

        private void refreshActiveCapeProviders() {
            Capes capes = Capes.instance();
            this.capeProviders = capes.getCapeProviderForSelf().map(List::of).orElseGet(capes::activeCapeProviders);
        }

        private void updateCapeAndElytraTexture() {
            this.capeTextureSupplier = null;
            this.elytraTextureSupplier = null;
            this.rebuildPayload();
            PlayerCapeHandlerManager playerCapeHandlerManager = Capes.instance().playerCapeHandlerManager();
            playerCapeHandlerManager.onLoadTexture(this.gameProfile, false, this.capeProviders, () -> {
                PlayerCapeHandler handler = playerCapeHandlerManager.getProfile(this.gameProfile);
                Supplier<class_2960> determinedCapeTextureSupplier = this.determineCapeIdentifierSupplier(handler);
                this.capeTextureSupplier = determinedCapeTextureSupplier;
                this.elytraTextureSupplier = handler == null || handler.hasElytraTexture() && Capes.instance().config().isEnableElytraTexture() ? determinedCapeTextureSupplier : DEFAULT_ELYTRA_SUPPLIER;
                this.rebuildPayload();
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        private Supplier<class_2960> determineCapeIdentifierSupplier(PlayerCapeHandler handler) {
            Supplier<class_2960> supplier;
            IdentifierProvider identifierProvider;
            if (handler != null && (identifierProvider = (IdentifierProvider)handler.capeIdentifierProvider().orElse(null)) != null) {
                if (identifierProvider.dynamicIdentifier()) {
                    return identifierProvider::identifier;
                }
                class_2960 identifier = identifierProvider.identifier();
                return () -> identifier;
            }
            Capes capes = Capes.instance();
            Optional<CapeProvider> provider = capes.getCapeProviderForSelf();
            if (!(provider.isEmpty() && capes.isUseDefaultProvider() || provider.filter(Capes.EXCLUDE_DEFAULT_MINECRAFT_CP).isEmpty())) {
                supplier = () -> null;
                return supplier;
            }
            supplier = () -> ((class_8685)this.skin).comp_1627();
            return supplier;
        }

        public void providerChanged() {
            this.refreshActiveCapeProviders();
            this.updateCapeAndElytraTexture();
        }

        public void toggleShowBody() {
            this.showBody = !this.showBody;
            this.rebuildPayload();
        }

        public void toggleShowElytra() {
            this.showElytra = !this.showElytra;
            this.rebuildPayload();
        }

        private void rebuildPayload() {
            this.payload = new PlayerDisplayGuiPayload(this.showBody ? this.skin.comp_1626() : null, this.capeTextureSupplier, this.showElytra ? this.elytraTextureSupplier : null, this.slim);
        }

        public PlayerDisplayGuiPayload getPayload() {
            return this.payload;
        }
    }

    static class PlayerLimbAnimator {
        private static final float LIMB_DISTANCE = -0.1f;
        private final int msBetweenUpdates;
        private long nextUpdateTimeMs;
        private float limbAngle;

        public PlayerLimbAnimator(int fps) {
            this.msBetweenUpdates = 1000 / fps;
        }

        public void animate(class_591 player, float tickDelta) {
            if (player == null) {
                return;
            }
            long currentTimeMs = System.currentTimeMillis();
            if (currentTimeMs > this.nextUpdateTimeMs) {
                this.nextUpdateTimeMs = currentTimeMs + (long)this.msBetweenUpdates;
                this.limbAngle += -0.1f;
            }
            float calcLimbAngle = this.limbAngle - -0.1f * (1.0f - tickDelta);
            float a = calcLimbAngle * 0.6662f;
            player.field_3401.field_3654 = class_3532.method_15362((float)(a + (float)Math.PI)) * 2.0f * -0.1f * 0.5f;
            player.field_27433.field_3654 = class_3532.method_15362((float)a) * 2.0f * -0.1f * 0.5f;
            player.field_3392.field_3654 = class_3532.method_15362((float)a) * 1.4f * -0.1f;
            player.field_3397.field_3654 = class_3532.method_15362((float)(a + (float)Math.PI)) * 1.4f * -0.1f;
        }
    }
}

