/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.litetex.capes.provider.antifeature.AntiFeature;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

public interface CapeProvider {
    public static final double DEFAULT_RATE_LIMIT_REQ_PER_SEC = 20.0;
    public static final int DEFAULT_MAX_DOWNLOAD_BYTES = 10000000;

    public String id();

    public String name();

    public String getBaseUrl(GameProfile var1);

    default public ResolvedTextureInfo resolveTexture(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, GameProfile profile) throws IOException, InterruptedException {
        return CapeProvider.resolveTextureDefault(clientBuilder, requestBuilder, this.textureResolverId());
    }

    default public String textureResolverId() {
        return null;
    }

    default public boolean hasChangeCapeUrl() {
        return false;
    }

    default public String changeCapeUrl(class_310 client) {
        return null;
    }

    default public String homepageUrl() {
        return null;
    }

    default public List<AntiFeature> antiFeatures() {
        return List.of();
    }

    default public double rateLimitedReqPerSec() {
        return 20.0;
    }

    public static ResolvedTextureInfo.ByteArrayTextureInfo resolveTextureDefault(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, String textureResolverId) throws IOException, InterruptedException {
        try (HttpClient client = clientBuilder.build();){
            ResolvedTextureInfo.ByteArrayTextureInfo byteArrayTextureInfo;
            block15: {
                HttpResponse<InputStream> response = client.send(requestBuilder.GET().build(), HttpResponse.BodyHandlers.ofInputStream());
                if (response.statusCode() / 100 != 2) {
                    ResolvedTextureInfo.ByteArrayTextureInfo byteArrayTextureInfo2 = null;
                    return byteArrayTextureInfo2;
                }
                BoundedInputStream cappedIS = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(response.body())).setMaxCount(10000000L)).get();
                try {
                    ResolvedTextureInfo.ByteArrayTextureInfo byteArrayTextureInfo3 = new ResolvedTextureInfo.ByteArrayTextureInfo(IOUtils.toByteArray((InputStream)cappedIS), textureResolverId);
                    if (cappedIS.getCount() >= 10000000L) {
                        throw new IllegalStateException("Aborted download because it exceeded the maximum allowed size: 10000000");
                    }
                    byteArrayTextureInfo = byteArrayTextureInfo3;
                    if (cappedIS == null) break block15;
                }
                catch (Throwable throwable) {
                    if (cappedIS != null) {
                        try {
                            cappedIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cappedIS.close();
            }
            return byteArrayTextureInfo;
        }
    }
}

