/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.litetex.capes.config.CustomProviderConfig;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.antifeature.AntiFeature;
import net.litetex.capes.provider.antifeature.AntiFeatures;
import net.litetex.capes.provider.antifeature.DefaultAntiFeature;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class CustomProvider
implements CapeProvider {
    private final CustomProviderConfig config;

    public CustomProvider(CustomProviderConfig config) {
        this.config = config;
    }

    @Override
    public String id() {
        return this.config.id();
    }

    @Override
    public String name() {
        return this.config.name();
    }

    @Override
    public String getBaseUrl(GameProfile profile) {
        String idString = profile.getId().toString();
        String uriTemplate = this.config.uriTemplate();
        if (uriTemplate.indexOf(36) != -1) {
            uriTemplate = this.fillInTemplate(uriTemplate, '$', idString, profile);
        } else if (uriTemplate.indexOf(167) != -1) {
            uriTemplate = this.fillInTemplate(uriTemplate, '\u00a7', idString, profile);
        }
        return uriTemplate;
    }

    protected String fillInTemplate(String uriTemplate, char prefix, String idString, GameProfile profile) {
        return uriTemplate.replace(prefix + "name", profile.getName()).replace(prefix + "id", idString).replace(prefix + "idNoHyphen", idString.replace("-", ""));
    }

    @Override
    public String textureResolverId() {
        String textureResolverId = this.config.textureResolverId();
        if (textureResolverId != null && !textureResolverId.isEmpty()) {
            return textureResolverId;
        }
        if (Boolean.TRUE.equals(this.config.animated())) {
            return "sprite";
        }
        return null;
    }

    @Override
    public boolean hasChangeCapeUrl() {
        return this.config.changeCapeUrl() != null;
    }

    @Override
    public String changeCapeUrl(class_310 client) {
        return this.config.changeCapeUrl();
    }

    @Override
    public String homepageUrl() {
        return this.config.homepage();
    }

    @Override
    public List<AntiFeature> antiFeatures() {
        if (this.config.antiFeatures() == null) {
            return List.of();
        }
        return this.config.antiFeatures().stream().filter(Objects::nonNull).map(s -> Optional.ofNullable(AntiFeatures.ALL_DEFAULT.get(s)).orElseGet(() -> new DefaultAntiFeature(class_2561.method_43470((String)s)))).toList();
    }

    @Override
    public double rateLimitedReqPerSec() {
        return this.config.rateLimitedReqPerSec() != null ? this.config.rateLimitedReqPerSec() : 20.0;
    }
}

