package net.litetex.capes.handler.textures;

import java.io.IOException;
import java.util.stream.IntStream;

import net.litetex.capes.handler.AnimatedNativeImageContainer;
import net.minecraft.class_1011;


public class AnimatedSpriteTextureResolver implements TextureResolver
{
	public static final String ID = "sprite";
	
	@Override
	public String id()
	{
		return ID;
	}
	
	@Override
	public boolean animated()
	{
		return true;
	}
	
	@Override
	public ResolvedTextureData resolve(final byte[] imageData, final boolean shouldOnlyResolveFirstFrame)
		throws IOException
	{
		try(final class_1011 img = class_1011.method_49277(imageData))
		{
			int totalFrames = img.method_4323() / (img.method_4307() / 2);
			if(shouldOnlyResolveFirstFrame)
			{
				totalFrames = Math.min(1, totalFrames);
			}
			
			return new AnimatedResolvedTextureData(IntStream.range(0, totalFrames)
				.mapToObj(currentFrame -> {
					final class_1011 frame = new class_1011(img.method_4307(), img.method_4307() / 2, true);
					for(int x = 0; x < frame.method_4307(); x++)
					{
						for(int y = 0; y < frame.method_4323(); y++)
						{
							frame.method_61941(x, y, img.method_61940(x, y + (currentFrame * (img.method_4307() / 2))));
						}
					}
					return frame;
				})
				.map(AnimatedNativeImageContainer::new)
				.toList());
		}
	}
}
