package net.litetex.capes.handler.textures;

import java.io.IOException;
import net.minecraft.class_1011;


public class DefaultTextureResolver implements TextureResolver
{
	public static final DefaultTextureResolver INSTANCE = new DefaultTextureResolver();
	
	@Override
	public String id()
	{
		return "default";
	}
	
	@Override
	public boolean animated()
	{
		return false;
	}
	
	@SuppressWarnings("checkstyle:MagicNumber")
	@Override
	public ResolvedTextureData resolve(final byte[] imageData, final boolean shouldOnlyResolveFirstFrame)
		throws IOException
	{
		try(final class_1011 img = class_1011.method_49277(imageData))
		{
			int imageWidth = 64;
			int imageHeight = 32;
			final int srcWidth = img.method_4307();
			final int srcHeight = img.method_4323();
			while(imageWidth < srcWidth || imageHeight < srcHeight)
			{
				imageWidth *= 2;
				imageHeight *= 2;
			}
			final class_1011 imgNew = new class_1011(imageWidth, imageHeight, true);
			for(int x = 0; x < srcWidth; x++)
			{
				for(int y = 0; y < srcHeight; y++)
				{
					imgNew.method_61941(x, y, img.method_61940(x, y));
				}
			}
			
			return new DefaultResolvedTextureData(imgNew, Math.floorDiv(srcWidth, srcHeight) == 2);
		}
	}
}
