package net.litetex.capes.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

import net.litetex.capes.Capes;
import net.litetex.capes.config.Config;
import net.litetex.capes.i18n.CapesI18NKeys;
import net.litetex.capes.menu.other.OtherMenuScreen;
import net.litetex.capes.menu.preview.PreviewMenuScreen;
import net.litetex.capes.menu.provider.ProviderMenuScreen;
import net.litetex.capes.util.CorrectHoverParentElement;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_6379;


public abstract class MainMenuScreen extends class_4667 implements CorrectHoverParentElement
{
	private final List<class_364> selfManagedDrawableChilds = new ArrayList<>();
	
	protected MainMenuScreen(
		final class_437 parent,
		final class_315 gameOptions)
	{
		super(parent, gameOptions, class_2561.method_43471(CapesI18NKeys.CAPE_OPTIONS));
	}
	
	@SuppressWarnings("checkstyle:MagicNumber")
	@Override
	protected void method_60329()
	{
		// The first "row" is used by the buttons for the individual screens
		this.field_51824 = this.field_49503.method_48999(
			new HeaderHeightOptionListWidget(this.field_22787, this.field_22789, this, 24));
		this.method_60325();
	}
	
	@SuppressWarnings("checkstyle:MagicNumber")
	protected void initSelfMangedDrawableChilds()
	{
		final int buttonW = 100;
		final int offset = (buttonW / 2) + 5;
		
		record ButtonBuildData(
			String translationKey,
			Supplier<class_437> screenSupplier,
			int positionDiff,
			Class<?> clazz
		)
		{
		}
		
		Stream.of(
				new ButtonBuildData(
					CapesI18NKeys.PREVIEW,
					() -> new PreviewMenuScreen(this.field_21335, this.field_21336),
					-(buttonW / 2),
					PreviewMenuScreen.class
				),
				new ButtonBuildData(
					CapesI18NKeys.MANAGE_PROVIDERS,
					() -> new ProviderMenuScreen(this.field_21335, this.field_21336),
					-(buttonW + offset),
					ProviderMenuScreen.class),
				new ButtonBuildData(
					CapesI18NKeys.OTHER,
					() -> new OtherMenuScreen(this.field_21335, this.field_21336),
					offset,
					OtherMenuScreen.class
				))
			.forEach(data -> {
				final class_4185 buttonWidget = this.addSelfManagedDrawableChild(class_4185.method_46430(
						class_2561.method_43471(data.translationKey()),
						b -> this.field_22787.method_1507(data.screenSupplier().get()))
					.method_46433((this.field_22789 / 2) + data.positionDiff(), 35)
					.method_46437(buttonW, 20)
					.method_46431());
				buttonWidget.field_22763 = !(data.clazz().isInstance(this));
			});
	}
	
	protected <T extends class_364 & class_4068 & class_6379> T addSelfManagedDrawableChild(final T drawableElement)
	{
		this.selfManagedDrawableChilds.add(drawableElement);
		return this.method_37063(drawableElement);
	}
	
	@Override
	protected void method_37067()
	{
		this.selfManagedDrawableChilds.clear();
		super.method_37067();
	}
	
	@Override
	protected void method_48640()
	{
		this.selfManagedDrawableChilds.forEach(this::method_37066);
		this.selfManagedDrawableChilds.clear();
		
		super.method_48640();
		
		this.initSelfMangedDrawableChilds();
	}
	
	@Override
	protected void method_60325()
	{
		// Nothing
	}
	
	protected Capes capes()
	{
		return Capes.instance();
	}
	
	protected Config config()
	{
		return this.capes().config();
	}
	
	@Override
	public void method_25419()
	{
		super.method_25419();
		this.capes().refreshIfMarked();
	}
	
	static class HeaderHeightOptionListWidget extends class_353
	{
		private final int headerHeight;
		
		public HeaderHeightOptionListWidget(
			final class_310 client,
			final int width,
			final class_4667 optionsScreen,
			final int headerHeight)
		{
			super(client, width, optionsScreen);
			this.headerHeight = headerHeight;
		}
		
		@Override
		protected int method_73376()
		{
			return super.method_73376() + this.headerHeight;
		}
		
		@Override
		protected int method_44395()
		{
			return super.method_44395() + this.headerHeight;
		}
	}
}
