package net.litetex.capes.menu;

import java.util.function.BiConsumer;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;


@SuppressWarnings("checkstyle:MagicNumber")
public class TickBoxWidget extends class_339
{
	private boolean ticked;
	private final BiConsumer<TickBoxWidget, Boolean> onTickChanged;
	
	public TickBoxWidget(
		final int size,
		final boolean ticked,
		final boolean readOnly,
		final BiConsumer<TickBoxWidget, Boolean> onTickChanged)
	{
		super(0, 0, size, size, class_2561.method_43473());
		this.field_22763 = !readOnly;
		this.ticked = ticked;
		this.onTickChanged = onTickChanged;
	}
	
	@Override
	protected void method_48579(final class_332 context, final int mouseX, final int mouseY, final float delta)
	{
		final int x = this.method_46426();
		final int y = this.method_46427();
		final int xEnd = x + this.method_25368();
		final int yEnd = y + this.method_25364();
		
		final int color = this.field_22763 ? 0xFFFFFFFF : 0xFFAAAAAA;
		
		if(this.ticked)
		{
			context.method_25294(x + 2, y + 2, xEnd - 2, yEnd - 2, color);
		}
		
		this.drawBorder(context, x, y, xEnd, yEnd, color);
	}
	
	private void drawBorder(
		final class_332 context,
		final int x1,
		final int y1,
		final int x2,
		final int y2,
		final int color)
	{
		context.method_25294(x1, y1, x2, y1 + 1, color);
		context.method_25294(x1, y2 - 1, x2, y2, color);
		context.method_25294(x1, y1, x1 + 1, y2, color);
		context.method_25294(x2 - 1, y1, x2, y2, color);
	}
	
	@Override
	public void method_25348(final class_11909 click, final boolean bl)
	{
		this.toggle();
	}
	
	public void toggle()
	{
		if(this.field_22763)
		{
			this.ticked = !this.ticked;
			this.onTickChanged.accept(this, this.ticked);
		}
	}
	
	public boolean isTicked()
	{
		return this.ticked;
	}
	
	@Override
	protected void method_47399(final class_6382 builder)
	{
	}
}
