package net.litetex.capes.menu.other;

import java.util.List;

import net.litetex.capes.Capes;
import net.litetex.capes.config.AnimatedCapesHandling;
import net.litetex.capes.config.ModProviderHandling;
import net.litetex.capes.i18n.CapesI18NKeys;
import net.litetex.capes.menu.MainMenuScreen;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;


public class OtherMenuScreen extends MainMenuScreen
{
	public OtherMenuScreen(
		final class_437 parent,
		final class_315 gameOptions)
	{
		super(parent, gameOptions);
	}
	
	@Override
	protected void method_60325()
	{
		final Capes capes = Capes.instance();
		
		this.field_51824.method_58227(List.of(
			class_5676.method_32613(capes.config().isOnlyLoadForSelf())
				.method_57720(
					class_2561.method_43471(CapesI18NKeys.ONLY_LOAD_YOUR_CAPE),
					(btn, enabled) -> {
						this.config().setOnlyLoadForSelf(enabled);
						capes.saveConfigAndMarkRefresh();
					}),
			class_5676.<AnimatedCapesHandling>method_32606(handling ->
					switch(handling)
					{
						case ON -> class_5244.field_24332;
						case FROZEN -> class_2561.method_43471(CapesI18NKeys.FROZEN);
						case OFF -> class_5244.field_24333;
					})
				.method_32619(this.config().getAnimatedCapesHandling())
				.method_32624(AnimatedCapesHandling.values())
				.method_57720(
					class_2561.method_43471(CapesI18NKeys.ANIMATED_TEXTURES),
					(btn, value) -> {
						this.config().setAnimatedCapesHandling(value);
						capes.saveConfigAndMarkRefresh();
					}),
			class_5676.method_32613(capes.config().isEnableElytraTexture())
				.method_57720(
					class_2561.method_43471(CapesI18NKeys.ELYTRA_TEXTURE),
					(btn, enabled) -> {
						this.config().setEnableElytraTexture(enabled);
						capes.saveConfig();
					}),
			class_5676.<ModProviderHandling>method_32606(handling ->
					switch(handling)
					{
						case ON -> class_5244.field_24332;
						case ONLY_LOAD -> class_2561.method_43471(CapesI18NKeys.LOAD);
						case OFF -> class_5244.field_24333;
					})
				.method_32619(this.config().getModProviderHandling())
				.method_32624(ModProviderHandling.values())
				.method_32618(value -> class_7919.method_47407(
					class_2561.method_43471(CapesI18NKeys.LOAD_PROVIDERS)
						.method_27693(": ")
						.method_10852(class_5244.method_36134(value.load()))
						.method_27693("\n")
						.method_10852(class_2561.method_43471(CapesI18NKeys.ACTIVATE_PROVIDERS_BY_DEFAULT))
						.method_27693(": ")
						.method_10852(class_5244.method_36134(value.activateByDefault()))))
				.method_57720(
					class_2561.method_43471(CapesI18NKeys.PROVIDERS_FROM_MODS),
					(btn, value) -> {
						this.config().setModProviderHandling(value);
						capes.saveConfig();
					})
		));
		
		this.field_51824.method_20407(
			class_4185.method_46430(
				class_2561.method_43471("controls.reset"), btn -> {
					this.config().reset();
					capes.saveConfigAndMarkRefresh();
					
					// Recreate screen
					this.field_22787.method_1507(new OtherMenuScreen(this.field_21335, this.field_21336));
				}).method_46431(),
			null);
	}
}
