package net.litetex.capes.menu.preview.render;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_11239;
import net.minecraft.class_12079;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.joml.Matrix4fStack;

import com.mojang.blaze3d.systems.RenderSystem;


@SuppressWarnings("checkstyle:MagicNumber")
public class PlayerDisplayGuiElementRenderer extends class_11239<PlayerDisplayGuiElementRenderState>
{
	private static final int LIGHT = 0xF000F0;
	
	public PlayerDisplayGuiElementRenderer(final class_4597.class_4598 immediate)
	{
		super(immediate);
	}
	
	@Override
	public Class<PlayerDisplayGuiElementRenderState> method_70903()
	{
		return PlayerDisplayGuiElementRenderState.class;
	}
	
	@Override
	protected void render(
		final PlayerDisplayGuiElementRenderState state,
		final class_4587 matrixStack)
	{
		class_310.method_1551().field_1773.method_71114()
			.method_71034(class_308.class_11274.field_60029);
		
		final int windowScaleFactor = class_310.method_1551().method_22683().method_4495();
		
		final Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
		matrix4fStack.pushMatrix();
		final float f = state.comp_4133() * windowScaleFactor;
		matrix4fStack.rotateAround(
			class_7833.field_40714.rotationDegrees(state.xRotation()),
			0.0F,
			f * -state.yPivot(),
			0.0F
		);
		matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-state.yRotation()));
		matrixStack.method_46416(0.0F, -1.6010001F, 0.0F);
		
		this.renderParts(state.payload(), state.models(), matrixStack);
		
		this.field_59933.method_22993();
		matrix4fStack.popMatrix();
	}
	
	protected void renderParts(
		final PlayerDisplayGuiPayload payload,
		final PlayerDisplayGuiModels models,
		final class_4587 matrixStack)
	{
		if(payload.bodyTexture() != null)
		{
			this.render(
				models.player(),
				matrixStack,
				this.field_59933.method_73477(models.player().method_23500(payload.bodyTexture().comp_3627())));
		}
		
		if(payload.elytraTextureSupplier() != null)
		{
			this.extractFromSupplierAndRender(
				payload.elytraTextureSupplier(), matrixStack, id ->
				{
					matrixStack.method_46416(0.0f, 0.0f, 0.125f);
					
					this.render(
						models.elytra(),
						matrixStack,
						this.field_59933.method_73477(class_1921.method_25448(id)));
				});
		}
		else if(payload.capeTextureSupplier() != null)
		{
			this.extractFromSupplierAndRender(
				payload.capeTextureSupplier(), matrixStack, id ->
				{
					matrixStack.method_22907(class_7833.field_40714.rotationDegrees(6.0f));
					
					this.render(
						models.cape().method_32086("body").method_32086("cape"),
						matrixStack,
						this.field_59933.method_73477(class_1921.method_25448(id))
					);
				});
		}
	}
	
	protected void extractFromSupplierAndRender(
		final Supplier<class_12079.class_12081> supplier,
		final class_4587 matrixStack,
		final Consumer<class_2960> renderer)
	{
		final class_12079.class_12081 textureAsset = supplier.get();
		if(textureAsset == null)
		{
			return;
		}
		
		final class_2960 id = textureAsset.comp_3627();
		if(id == null)
		{
			return;
		}
		
		matrixStack.method_22903();
		renderer.accept(id);
		matrixStack.method_22909();
	}
	
	protected void render(final class_3879<?> model, final class_4587 stack, final class_4588 c)
	{
		model.method_60879(stack, c, LIGHT, class_4608.field_21444);
	}
	
	protected void render(final class_630 modelPart, final class_4587 stack, final class_4588 c)
	{
		modelPart.method_22698(stack, c, LIGHT, class_4608.field_21444);
	}
	
	@Override
	protected String method_70906()
	{
		return "player display";
	}
}
