package net.litetex.capes.menu.preview.render;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_332;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_563;
import net.minecraft.class_630;
import net.minecraft.class_8765;


@SuppressWarnings("checkstyle:MagicNumber")
public class PlayerDisplayWidget extends class_8765
{
	private final Supplier<PlayerDisplayGuiPayload> payloadSupplier;
	private final Consumer<PlayerDisplayGuiModels> preModelRenderAction;
	
	private final class_563 elytraEntityModel;
	private final class_630 capeModel;
	
	public PlayerDisplayWidget(
		final int width,
		final int height,
		final class_5599 entityModels,
		final Supplier<PlayerDisplayGuiPayload> payloadSupplier,
		final Consumer<PlayerDisplayGuiModels> preModelRenderAction)
	{
		super(width, height, entityModels, null);
		this.payloadSupplier = payloadSupplier;
		this.preModelRenderAction = preModelRenderAction;
		
		this.elytraEntityModel = new class_563(entityModels.method_32072(class_5602.field_27559));
		this.capeModel = entityModels.method_32072(class_5602.field_52980);
	}
	
	@Override
	protected void method_48579(final class_332 context, final int mouseX, final int mouseY, final float deltaTicks)
	{
		final PlayerDisplayGuiPayload payload = this.payloadSupplier.get();
		
		final PlayerDisplayGuiModels models = new PlayerDisplayGuiModels(
			payload.slim() ? this.field_59835 : this.field_59834,
			this.elytraEntityModel,
			this.capeModel
		);
		this.preModelRenderAction.accept(models);
		
		this.addToDrawContext(
			context,
			models,
			payload,
			0.97F * this.method_25364() / 2.125F,
			this.field_46005,
			this.field_46006,
			-1.0625F,
			this.method_46426(),
			this.method_46427(),
			this.method_55442(),
			this.method_55443());
	}
	
	@SuppressWarnings("PMD.ExcessiveParameterList") // Derived from MC code
	public void addToDrawContext(
		final class_332 context,
		final PlayerDisplayGuiModels models,
		final PlayerDisplayGuiPayload payload,
		final float scale,
		final float xRotation,
		final float yRotation,
		final float yPivot,
		final int x1,
		final int y1,
		final int x2,
		final int y2)
	{
		context.field_59826.method_70922(new PlayerDisplayGuiElementRenderState(
			models,
			payload,
			xRotation,
			yRotation,
			yPivot,
			x1,
			y1,
			x2,
			y2,
			scale,
			context.field_44659.method_70863()));
	}
}
