package net.litetex.capes.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import net.litetex.capes.Capes;
import net.litetex.capes.menu.preview.PreviewMenuScreen;
import net.litetex.capes.util.CorrectHoverParentElement;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_437;
import net.minecraft.class_440;
import net.minecraft.class_4667;
import net.minecraft.class_8662;


@Mixin(class_440.class)
public abstract class SkinOptionsScreenMixin extends class_4667 implements CorrectHoverParentElement
{
	@Unique
	private static final class_2960 CAPE_OPTIONS_ICON_TEXTURE = class_2960.method_60655(Capes.MOD_ID, "icon/cape_options");
	
	@Unique
	private class_8662 btnCapeMenu;
	
	protected SkinOptionsScreenMixin(
		final class_437 parent,
		final class_315 gameOptions,
		final class_2561 title)
	{
		super(parent, gameOptions, title);
	}
	
	@SuppressWarnings("checkstyle:MagicNumber")
	@Override
	protected void method_25426()
	{
		super.method_25426();
		
		// It's important that this is added after all other elements have been added
		// Else it's rendered behind other elements
		this.btnCapeMenu = this.method_37063(class_8662.method_52723(
				class_2561.method_43473(),
				ignored -> this.field_22787.method_1507(new PreviewMenuScreen(
					this,
					this.field_21336)),
				true)
			.method_52726(20, 20)
			.method_52727(CAPE_OPTIONS_ICON_TEXTURE, 16, 16)
			.method_52724());
		
		this.updateRelativePositions();
	}
	
	@Unique
	@SuppressWarnings("checkstyle:MagicNumber")
	private void updateRelativePositions()
	{
		this.btnCapeMenu.method_48229(this.field_51824.method_25342() - 25, this.field_51824.method_46427() + 4);
	}
	
	@Override
	protected void method_48640()
	{
		super.method_48640();
		
		if(this.btnCapeMenu != null) // Init check
		{
			this.updateRelativePositions();
		}
	}
}
