package net.litetex.capes.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_364;
import net.minecraft.class_4069;


public interface CorrectHoverParentElement extends class_4069
{
	// Fixes click and hover not working when element/button is rendered on top!
	@Override
	default Optional<class_364> method_19355(final double mouseX, final double mouseY)
	{
		// ParentElement#hoveredElement checks the elements in the incorrect order! (Bottom -> Top)
		// It should do that from top to bottom, as only the top-most element can be clicked/hovered!
		
		// Defensive copy against modification on the fly
		final List<? extends class_364> children = new ArrayList<>(this.method_25396());
		for(int i = children.size() - 1; i >= 0; i--)
		{
			final class_364 element = children.get(i);
			if(element.method_25405(mouseX, mouseY))
			{
				return Optional.of(element);
			}
		}
		
		return Optional.empty();
	}
}
