/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CapesMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(CapesMixinPlugin.class);
    private static final String MIXIN_PACKAGE = "net.litetex.capes.mixins.";
    private static final String MIXIN_COMPAT_PACKAGE = "net.litetex.capes.mixins.compat.";
    static final Map<String, BooleanSupplier> CONDITIONS = Map.of();
    static final Map<String, String> PACKAGE_MOD_ID_OVERWRITE = Map.of();
    static final Set<String> APPLIED_MOD_ID_COMPATS = new HashSet<String>();

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean apply;
        BooleanSupplier supplier;
        Boolean shouldApply = null;
        String compatModId = null;
        if (mixinClassName.startsWith(MIXIN_COMPAT_PACKAGE)) {
            String packageModId = mixinClassName.substring(MIXIN_COMPAT_PACKAGE.length()).split("\\.")[0];
            compatModId = PACKAGE_MOD_ID_OVERWRITE.getOrDefault(packageModId, packageModId);
            shouldApply = FabricLoader.getInstance().isModLoaded(compatModId);
        }
        boolean bl = (supplier = CONDITIONS.get(mixinClassName)) == null ? !Boolean.FALSE.equals(shouldApply) : (apply = supplier.getAsBoolean());
        if (apply) {
            LOG.debug("Applying {}", (Object)mixinClassName);
            if (compatModId != null && !APPLIED_MOD_ID_COMPATS.contains(compatModId) && APPLIED_MOD_ID_COMPATS.add(compatModId)) {
                LOG.info("Applying compat for '{}'", (Object)compatModId);
            }
        }
        return apply;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

