/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.litetex.capes.Capes;
import net.litetex.capes.config.Config;
import net.litetex.capes.fabric.FabricModMetadataProviderSupplier;
import net.litetex.capes.handler.textures.suppliers.TextureResolvers;
import net.litetex.capes.menu.preview.render.PlayerDisplayGuiElementRenderer;
import net.litetex.capes.provider.suppliers.CapeProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricCapes
implements ClientModInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(FabricCapes.class);
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantConverter()).setPrettyPrinting().create();

    public void onInitializeClient() {
        SpecialGuiElementRegistry.register(ctx -> new PlayerDisplayGuiElementRenderer(ctx.vertexConsumers()));
        Config config = this.loadConfig();
        Capes.setInstance(new Capes(config, this::saveConfig, CapeProviders.findAllProviders(config.getCustomProviders(), config.getModProviderHandling().load() ? new FabricModMetadataProviderSupplier() : null), TextureResolvers.findAllResolvers()));
        LOG.debug("Initialized");
    }

    private Path configFilePath() {
        return FabricLoader.getInstance().getConfigDir().resolve("cape-provider-x.json5");
    }

    private Config loadConfig() {
        Path configFilePath = this.configFilePath();
        if (Files.exists(configFilePath, new LinkOption[0])) {
            try {
                return (Config)this.gson.fromJson(Files.readString(configFilePath), Config.class);
            }
            catch (Exception ex) {
                LOG.warn("Failed to read config file", (Throwable)ex);
            }
        }
        Config defaultConfig = Config.createDefault();
        this.saveConfig(defaultConfig);
        return defaultConfig;
    }

    private void saveConfig(Config config) {
        try {
            Files.writeString(this.configFilePath(), (CharSequence)this.gson.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to save config", ioe);
        }
    }

    static class InstantConverter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        InstantConverter() {
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(FORMATTER.format(src));
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            return FORMATTER.parse((CharSequence)json.getAsString(), Instant::from);
        }
    }
}

