/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.handler;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.litetex.capes.Capes;
import net.litetex.capes.handler.PlayerCapeHandler;
import net.litetex.capes.handler.RealPlayerValidator;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ratelimit.CapeProviderRateLimits;
import net.litetex.capes.util.GameProfileUtil;
import net.litetex.capes.util.collections.DiscardingQueue;
import net.litetex.capes.util.collections.MaxSizedHashMap;
import net.minecraft.class_143;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerCapeHandlerManager {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerCapeHandlerManager.class);
    private final ExecutorService loadExecutors;
    private final Map<UUID, PlayerCapeHandler> instances;
    private final RealPlayerValidator realPlayerValidator;
    private final Map<Future<?>, UUID> submittedTasks = Collections.synchronizedMap(new WeakHashMap());
    private final CapeProviderRateLimits capeProviderRateLimits = new CapeProviderRateLimits();
    private final Capes capes;
    private final boolean debugEnabled;

    public PlayerCapeHandlerManager(Capes capes) {
        this.capes = capes;
        this.debugEnabled = LOG.isDebugEnabled();
        int nThreads = Optional.ofNullable(capes.config().getLoadThreads()).filter(x -> x > 0 && x < 1000).orElse(2);
        int loadExecutorWorkQueueSize = Math.max(capes.playerCacheSize() / 10, 10);
        LOG.debug("LoadExecutor threads={} workQueue size={}", (Object)nThreads, (Object)loadExecutorWorkQueueSize);
        this.loadExecutors = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new DiscardingQueue<Runnable>(loadExecutorWorkQueueSize, r -> LOG.warn("Overloaded - Discarded loading task for {}", (Object)this.submittedTasks.get(r))), new ThreadFactory(this){
            private static final AtomicInteger COUNTER = new AtomicInteger(0);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("Cape-" + COUNTER.getAndIncrement());
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_143(LOG));
                return thread;
            }
        });
        this.instances = Collections.synchronizedMap(new MaxSizedHashMap(capes.playerCacheSize()));
        this.realPlayerValidator = new RealPlayerValidator(capes.playerCacheSize(), capes.useRealPlayerOnlineValidation());
    }

    public PlayerCapeHandler getProfile(GameProfile profile) {
        return this.instances.get(profile.id());
    }

    public PlayerCapeHandler getOrCreateProfile(GameProfile profile) {
        return this.instances.computeIfAbsent(profile.id(), ignored -> new PlayerCapeHandler(this.capes, profile));
    }

    public void clearCache() {
        this.instances.clear();
    }

    public void onLoadTexture(GameProfile profile) {
        this.onLoadTexture(profile, this.capes.validateProfile(), this.capes.activeCapeProviders(), null);
    }

    public void onLoadTexture(GameProfile profile, boolean validateProfile, Collection<CapeProvider> capeProviders, Runnable onAfterLoaded) {
        if (this.debugEnabled) {
            LOG.debug("onLoadTexture: {}/{} validate={}", new Object[]{profile.name(), profile.id(), validateProfile});
        }
        Runnable runnable = () -> {
            try {
                this.onLoadTextureInternalAsync(profile, validateProfile, capeProviders, onAfterLoaded);
            }
            catch (Exception ex) {
                LOG.warn("Failed to async load texture for {}/{}", new Object[]{profile.name(), profile.id(), ex});
            }
        };
        this.submittedTasks.put(this.loadExecutors.submit(runnable), profile.id());
    }

    private void onLoadTextureInternalAsync(GameProfile profile, boolean validateProfile, Collection<CapeProvider> capeProviders, Runnable onAfterLoaded) {
        if (this.shouldOnlyLoadForSelfAndIsNotSelf(profile) || validateProfile && !capeProviders.isEmpty() && !this.realPlayerValidator.isReal(profile)) {
            return;
        }
        PlayerCapeHandler handler = this.getOrCreateProfile(profile);
        handler.resetCape();
        Optional<CapeProvider> optFoundCapeProvider = capeProviders.stream().filter(cp -> {
            this.capeProviderRateLimits.waitForRateLimit((CapeProvider)cp);
            return handler.trySetCape((CapeProvider)cp);
        }).findFirst();
        if (LOG.isDebugEnabled()) {
            optFoundCapeProvider.ifPresentOrElse(cp -> LOG.debug("Loaded cape from {} for {}/{}", new Object[]{cp.id(), profile.name(), profile.id()}), () -> LOG.debug("Found no cape for {}/{}", (Object)profile.name(), (Object)profile.id()));
        }
        if (onAfterLoaded != null) {
            onAfterLoaded.run();
        }
    }

    private boolean shouldOnlyLoadForSelfAndIsNotSelf(GameProfile profile) {
        return this.capes.config().isOnlyLoadForSelf() && !GameProfileUtil.isSelf(profile);
    }
}

