/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.minecraft.class_310;

public class CosmeticaProvider
implements CapeProvider {
    @Override
    public String id() {
        return "cosmetica";
    }

    @Override
    public String name() {
        return "Cosmetica";
    }

    @Override
    public String getBaseUrl(GameProfile profile) {
        return "https://api.cosmetica.cc/v2/get/info?uuid=" + profile.id().toString();
    }

    @Override
    public ResolvedTextureInfo resolveTexture(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, GameProfile profile) throws IOException, InterruptedException {
        try (HttpClient client = clientBuilder.build();){
            JsonObject root;
            requestBuilder.header("Accept", "application/json");
            HttpRequest request = requestBuilder.GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            try {
                root = JsonParser.parseString((String)response.body()).getAsJsonObject();
            }
            catch (Exception ex) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                if (client != null) {
                    client.close();
                }
                return resolvedTextureInfo;
            }
            if (root == null) {
                ResolvedTextureInfo ex = null;
                return ex;
            }
            String texture = CosmeticaProvider.getImage(root, "capes");
            if (texture == null) {
                texture = CosmeticaProvider.getImage(root, "cape");
            }
            if (texture == null || texture.isEmpty()) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            texture = CosmeticaProvider.stripDataUri(texture);
            ResolvedTextureInfo.Base64TextureInfo base64TextureInfo = new ResolvedTextureInfo.Base64TextureInfo(texture, "sprite");
            return base64TextureInfo;
        }
    }

    private static String getImage(JsonObject root, String parentKey) {
        String s;
        JsonObject obj;
        if (root.has(parentKey) && !root.get(parentKey).isJsonNull() && (obj = root.getAsJsonObject(parentKey)) != null && obj.has("image") && !obj.get("image").isJsonNull() && (s = obj.get("image").getAsString()) != null && !s.isEmpty()) {
            return s;
        }
        return null;
    }

    private static String stripDataUri(String value) {
        int commaIdx;
        if (value != null && value.startsWith("data:") && (commaIdx = value.indexOf(44)) > 0 && commaIdx + 1 < value.length()) {
            return value.substring(commaIdx + 1);
        }
        return value;
    }

    @Override
    public boolean hasChangeCapeUrl() {
        return true;
    }

    @Override
    public String changeCapeUrl(class_310 client) {
        return "https://login.cosmetica.cc";
    }

    @Override
    public String homepageUrl() {
        return "https://cosmetica.cc/";
    }
}

