/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.minecraft.class_155;
import net.minecraft.class_310;

public class MinecraftCapesCapeProvider
implements CapeProvider {
    public static final String ID = "minecraftcapes";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return "MinecraftCapes";
    }

    @Override
    public String getBaseUrl(GameProfile profile) {
        return "https://api.minecraftcapes.net/profile/" + profile.id().toString().replace("-", "");
    }

    @Override
    public ResolvedTextureInfo resolveTexture(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, GameProfile profile) throws IOException, InterruptedException {
        requestBuilder.setHeader("User-Agent", "minecraftcapes-mod/" + class_155.method_16673().comp_4025());
        try (HttpClient client = clientBuilder.build();){
            ResponseData responseData;
            HttpResponse<String> response = client.send(requestBuilder.GET().build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            record ResponseData(Boolean animatedCape, Map<String, String> textures) {
            }
            ResolvedTextureInfo.Base64TextureInfo base64TextureInfo = new ResolvedTextureInfo.Base64TextureInfo(responseData.textures().get("cape"), (responseData = (ResponseData)new Gson().fromJson(response.body(), ResponseData.class)).animatedCape() != false ? "sprite" : null);
            return base64TextureInfo;
        }
    }

    @Override
    public boolean hasChangeCapeUrl() {
        return true;
    }

    @Override
    public String changeCapeUrl(class_310 client) {
        return this.homepageUrl();
    }

    @Override
    public String homepageUrl() {
        return "https://minecraftcapes.net";
    }
}

