/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.capes.provider;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import net.litetex.capes.provider.CapeProvider;
import net.litetex.capes.provider.ResolvedTextureInfo;
import net.minecraft.class_155;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiCapesCapeProvider
implements CapeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PiCapesCapeProvider.class);
    public static final String ID = "picapesmod";
    private static String serverHost;
    private static String modNameDefault;
    private static String modName;
    private static boolean initialized;

    public static void initializeServerHost() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://picapes.github.io/api/server.json")).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 == 2) {
                Map json = (Map)new Gson().fromJson(response.body(), Map.class);
                Object ip = json.get("serverHost");
                if (ip != null) {
                    serverHost = ip.toString();
                    LOG.info("[PiCapes] Server host found: {}", (Object)serverHost);
                } else {
                    LOG.warn("[PiCapes] Server host not found in response JSON.");
                }
                Object nameObj = json.get("name");
                if (nameObj != null && !nameObj.toString().isEmpty()) {
                    modName = nameObj.toString();
                    LOG.info("[PiCapes] Mod name set from API: {}", (Object)modName);
                } else {
                    LOG.warn("[PiCapes] Mod name not found in response JSON, using fallback.");
                }
            } else {
                LOG.warn("[PiCapes] Server host API returned status code: {}", (Object)response.statusCode());
            }
        }
        catch (Exception e) {
            LOG.error("[PiCapes] Failed to fetch server host from API.", (Throwable)e);
            serverHost = null;
            modName = modNameDefault;
        }
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return modName != null && !modName.isEmpty() ? modName : modNameDefault;
    }

    @Override
    public String getBaseUrl(GameProfile profile) {
        if (serverHost == null || serverHost.isEmpty()) {
            PiCapesCapeProvider.initializeServerHost();
            if (serverHost == null || serverHost.isEmpty()) {
                return null;
            }
        }
        return serverHost + "/profile/" + profile.name();
    }

    @Override
    public ResolvedTextureInfo resolveTexture(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, GameProfile profile) throws IOException, InterruptedException {
        requestBuilder.setHeader("User-Agent", "picapes-mod/" + class_155.method_16673().comp_4025());
        try (HttpClient client = clientBuilder.build();){
            HttpResponse<String> response = client.send(requestBuilder.GET().build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            record ResponseData(Boolean animatedCape, String textureURL) {
            }
            ResponseData responseData = (ResponseData)new Gson().fromJson(response.body(), ResponseData.class);
            if (responseData.textureURL() == null || responseData.textureURL().isEmpty()) {
                ResolvedTextureInfo resolvedTextureInfo = null;
                return resolvedTextureInfo;
            }
            ResolvedTextureInfo.UrlTextureInfo urlTextureInfo = new ResolvedTextureInfo.UrlTextureInfo(responseData.textureURL(), responseData.animatedCape() != false ? "sprite" : null);
            return urlTextureInfo;
        }
    }

    @Override
    public double rateLimitedReqPerSec() {
        return 10.0;
    }

    @Override
    public boolean hasChangeCapeUrl() {
        return true;
    }

    @Override
    public String changeCapeUrl(class_310 client) {
        return "https://picapes.syanic.org/changeCape";
    }

    @Override
    public String homepageUrl() {
        return "https://picapes.syanic.org/";
    }

    static {
        PiCapesCapeProvider.initializeServerHost();
        serverHost = "";
        modNameDefault = "PiCapes";
        modName = "PiCapes";
        initialized = false;
    }
}

