/*
 * Decompiled with CFR 0.152.
 */
package flanox.fr.lagBuster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class LagBuster
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean autoClear = false;
    private BukkitTask task = null;
    private BossBar bossBar = null;
    private int totalSeconds = 0;
    private int countdownSeconds = 0;

    public void onEnable() {
        this.saveDefaultConfig();
        this.autoClear = this.getConfig().getBoolean("settings.autoClear.enabled");
        this.countdownSeconds = this.totalSeconds = this.getConfig().getInt("settings.autoClear.intervalMinutes") * 60;
        this.getCommand("clearlag").setExecutor((CommandExecutor)this);
        this.getCommand("clearlag").setTabCompleter((TabCompleter)this);
        if (this.autoClear) {
            this.startAutoClear();
        }
    }

    public void onDisable() {
        this.stopAutoClear();
    }

    private void startAutoClear() {
        this.stopAutoClear();
        this.bossBar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.GREEN) + "Next ClearLag"), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.bossBar.addPlayer(p);
        }
        this.bossBar.setProgress(1.0);
        this.task = new BukkitRunnable(){

            public void run() {
                --LagBuster.this.countdownSeconds;
                double progress = (double)LagBuster.this.countdownSeconds / (double)LagBuster.this.totalSeconds;
                LagBuster.this.bossBar.setProgress(Math.max(0.0, progress));
                if (LagBuster.this.countdownSeconds <= 0) {
                    LagBuster.this.executeClear();
                    LagBuster.this.countdownSeconds = LagBuster.this.totalSeconds;
                    LagBuster.this.bossBar.setProgress(1.0);
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    private void stopAutoClear() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBar = null;
        }
    }

    private void executeClear() {
        int removed = 0;
        boolean removeItems = this.getConfig().getBoolean("settings.removeEntities.items");
        boolean removeMobs = this.getConfig().getBoolean("settings.removeEntities.mobs");
        boolean removeProjectiles = this.getConfig().getBoolean("settings.removeEntities.projectiles");
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : new ArrayList(world.getEntities())) {
                if (removeItems && entity instanceof Item) {
                    entity.remove();
                    ++removed;
                    continue;
                }
                if (removeProjectiles && entity instanceof Projectile) {
                    entity.remove();
                    ++removed;
                    continue;
                }
                if (!removeMobs || !(entity instanceof Mob) || entity instanceof Player) continue;
                entity.remove();
                ++removed;
            }
        }
        String message = removed == 0 ? this.getConfig().getString("messages.clearlag.no_entities") : this.getConfig().getString("messages.clearlag.cleared").replace("%count%", String.valueOf(removed));
        this.sendMessageToAll(message);
    }

    private void sendMessageToAll(String msg) {
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("clearlag")) {
            if (args.length < 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.getConfig().getString("messages.command.usage"));
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "on": {
                    this.startAutoClear();
                    this.autoClear = true;
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "LagBuster automatic enabled!");
                    break;
                }
                case "off": {
                    this.stopAutoClear();
                    this.autoClear = false;
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "LagBuster automatic disabled!");
                    break;
                }
                case "clear": {
                    this.executeClear();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "LagBuster executed now!");
                    break;
                }
                case "reload": {
                    this.reloadConfig();
                    this.countdownSeconds = this.totalSeconds = this.getConfig().getInt("settings.autoClear.intervalMinutes") * 60;
                    if (this.autoClear) {
                        this.stopAutoClear();
                        this.startAutoClear();
                    }
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "LagBuster reloaded!");
                    break;
                }
                case "timeset": {
                    if (args.length != 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearlag timeset <minutes>");
                        return true;
                    }
                    try {
                        int minutes = Integer.parseInt(args[1]);
                        if (minutes <= 0) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Time must be greater than 0!");
                            return true;
                        }
                        this.countdownSeconds = this.totalSeconds = minutes * 60;
                        this.getConfig().set("settings.autoClear.intervalMinutes", (Object)minutes);
                        this.saveConfig();
                        if (this.autoClear) {
                            this.stopAutoClear();
                            this.startAutoClear();
                        }
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "LagBuster interval updated to " + minutes + " minutes.");
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number.");
                    }
                    break;
                }
                default: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + this.getConfig().getString("messages.command.usage"));
                }
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("clearlag") && args.length == 1) {
            return Arrays.asList("on", "off", "clear", "reload", "timeset");
        }
        return null;
    }
}

