/*
 * Decompiled with CFR 0.152.
 */
package com.smm.dcp.client;

import com.smm.dcp.client.DcpConfig;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class DcpClient
implements ClientModInitializer {
    public static DcpConfig CONFIG;
    private static final int DEFAULT_TICKS_BETWEEN_UPDATES = 20;
    private static final int SLOW_UPDATE_TICKS = 100;
    private int tickCounter = 0;
    private long recordedTick = -1L;
    private long lastTotalTicks = -1L;
    private long lastOverlayDayShown = -1L;
    private long lastSoundDayPlayed = -1L;
    private boolean pendingNewDaySound = false;
    private boolean displaying = false;
    private static class_304 toggleKeybind;
    private boolean togglePressedLastTick = false;
    private int cachedDynamicColor = -1;
    private int cachedDynamicSeparator = -1;
    private long colorCacheLastUpdatedTick = -1L;
    private String lastRenderedPlain = "";
    private class_5250 lastRenderedText = null;
    private int lastRenderedColor = -1;
    private int lastRenderedSeparator = -1;
    private class_5251 lastMainTextColor = null;
    private class_5251 lastSeparatorTextColor = null;
    private class_2338 lastBiomeSamplePos = null;
    private int lastBiomeSampledColor = -1;
    private long lastBiomeCheckTick = 0L;
    private final Map<Integer, Integer[]> dynamicColorCache = new HashMap<Integer, Integer[]>();
    private Integer lastBaseColorChecked = null;
    private NumberFormat cachedNumberFormat = null;
    private DcpConfig.ThousandSeparatorMode lastNumberFormatMode = null;
    private Locale lastLocale = null;
    private static final Map<String, Integer> BIOME_COLOR_MAP;
    private class_1109 lastToggleSound = null;

    public void onInitializeClient() {
        CONFIG = DcpConfig.load();
        class_304.class_11900 dcpCategory = new class_304.class_11900(class_2960.method_60655((String)"dcp", (String)"daycounterplus"));
        toggleKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.dcp.toggle_daycounter", class_3675.class_307.field_1668, 66, dcpCategory));
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private void reset(class_310 client) {
        if (this.displaying && client.field_1705 != null) {
            client.field_1705.method_1758((class_2561)class_2561.method_43473(), false);
        }
        this.tickCounter = 0;
        this.recordedTick = -1L;
        this.lastTotalTicks = -1L;
        this.displaying = false;
        this.colorCacheLastUpdatedTick = -1L;
        this.lastBiomeCheckTick = 0L;
        this.lastBaseColorChecked = null;
        this.lastRenderedPlain = "";
        this.lastRenderedText = null;
        this.lastRenderedColor = -1;
        this.lastRenderedSeparator = -1;
        this.lastMainTextColor = null;
        this.lastSeparatorTextColor = null;
    }

    private boolean isSingleplayer(class_310 client) {
        try {
            return client.method_1542();
        }
        catch (Throwable ignored) {
            return client.field_1687 != null && client.field_1687.method_8608();
        }
    }

    private void onClientTick(class_310 client) {
        String plain;
        boolean needsColorUpdate;
        long total;
        if (toggleKeybind != null) {
            boolean currentlyPressed = toggleKeybind.method_1434();
            if (currentlyPressed && !this.togglePressedLastTick) {
                DcpClient.CONFIG.enabled = !DcpClient.CONFIG.enabled;
                CONFIG.save();
                if (!DcpClient.CONFIG.enabled) {
                    if (DcpClient.CONFIG.playToggleVisibilitySound) {
                        this.playToggleSound(client, class_3417.field_19344);
                    }
                    this.reset(client);
                } else {
                    if (client.field_1687 != null && client.field_1705 != null) {
                        this.recordedTick = total = client.field_1687.method_8532();
                        this.lastTotalTicks = total;
                        this.tickCounter = 0;
                        this.displaying = true;
                        try {
                            this.colorCacheLastUpdatedTick = -1L;
                            this.lastBiomeCheckTick = 0L;
                            class_5250 msg = this.buildOverlayMessage(client, total, true);
                            client.field_1705.method_1758((class_2561)msg, false);
                            this.lastRenderedText = msg;
                            this.lastRenderedPlain = this.buildPlainString(total);
                            this.lastRenderedColor = this.cachedDynamicColor;
                            this.lastRenderedSeparator = this.cachedDynamicSeparator;
                            if (this.pendingNewDaySound) {
                                this.playConfiguredSound(client);
                                this.pendingNewDaySound = false;
                            }
                        }
                        catch (Throwable msg) {
                            // empty catch block
                        }
                    }
                    if (DcpClient.CONFIG.playToggleVisibilitySound) {
                        this.playToggleSound(client, class_3417.field_14703);
                    }
                }
            }
            this.togglePressedLastTick = currentlyPressed;
        }
        if (client.field_1687 == null || client.field_1705 == null || client.field_1724 == null) {
            this.reset(client);
            return;
        }
        if (!DcpClient.CONFIG.enabled) {
            this.reset(client);
            return;
        }
        boolean single = this.isSingleplayer(client);
        if (!DcpClient.CONFIG.enableOnSingleplayer && single || !DcpClient.CONFIG.enableOnMultiplayer && !single) {
            this.reset(client);
            return;
        }
        total = client.field_1687.method_8532();
        long currentDay = total / 24000L;
        if (this.lastSoundDayPlayed == -1L) {
            this.lastSoundDayPlayed = currentDay;
        } else if (currentDay > this.lastSoundDayPlayed) {
            this.lastSoundDayPlayed = currentDay;
            this.playConfiguredSound(client);
        }
        if (!this.displaying) {
            if (this.recordedTick == -1L) {
                this.recordedTick = total;
                return;
            }
            if (total > this.recordedTick) {
                this.displaying = true;
                this.lastTotalTicks = total;
            } else {
                this.recordedTick = total;
                return;
            }
        }
        int ticksBetween = 20;
        class_2338 currentPos = client.field_1724.method_24515();
        boolean isSlowTickTime = this.lastBiomeCheckTick == 0L || total - this.lastBiomeCheckTick >= 100L || this.lastBiomeCheckTick > total;
        boolean playerMoved = this.lastBiomeSamplePos == null || !currentPos.equals((Object)this.lastBiomeSamplePos);
        boolean bl = needsColorUpdate = isSlowTickTime || DcpClient.CONFIG.dynamicColors && playerMoved || this.colorCacheLastUpdatedTick == -1L || this.colorCacheLastUpdatedTick > total;
        if (needsColorUpdate) {
            this.lastBiomeCheckTick = total;
            int baseColor = DcpClient.CONFIG.dynamicColors ? this.getBiomeOrDimensionColor(client, currentPos, playerMoved) : DcpClient.CONFIG.dayColor;
            Integer[] cachedDynamic = this.dynamicColorCache.get(baseColor);
            if (cachedDynamic != null && this.lastBaseColorChecked != null && this.lastBaseColorChecked.equals(baseColor)) {
                this.cachedDynamicColor = cachedDynamic[0];
                this.cachedDynamicSeparator = cachedDynamic[1];
            } else {
                this.cachedDynamicColor = DcpClient.lightenIfDark(baseColor, 1.2);
                this.cachedDynamicSeparator = DcpClient.darkenColor(this.cachedDynamicColor, 0.75);
                this.dynamicColorCache.put(baseColor, new Integer[]{this.cachedDynamicColor, this.cachedDynamicSeparator});
            }
            this.lastBaseColorChecked = baseColor;
            this.colorCacheLastUpdatedTick = total;
            this.lastRenderedColor = -1;
            this.lastRenderedSeparator = -1;
            this.lastMainTextColor = null;
            this.lastSeparatorTextColor = null;
        }
        if (!(plain = this.buildPlainString(total)).equals(this.lastRenderedPlain) || this.lastRenderedColor != this.cachedDynamicColor || this.lastRenderedSeparator != this.cachedDynamicSeparator) {
            try {
                class_5250 msg = this.buildOverlayMessage(client, total, false);
                client.field_1705.method_1758((class_2561)msg, false);
                this.lastRenderedPlain = plain;
                this.lastRenderedText = msg;
                this.lastRenderedColor = this.cachedDynamicColor;
                this.lastRenderedSeparator = this.cachedDynamicSeparator;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (++this.tickCounter < 20) {
            return;
        }
        this.tickCounter = 0;
        if (total <= this.lastTotalTicks) {
            this.reset(client);
            this.recordedTick = total;
            return;
        }
        this.lastTotalTicks = total;
        if (DcpClient.CONFIG.onlyShowOnNewDay) {
            if (this.lastOverlayDayShown == -1L) {
                this.lastOverlayDayShown = currentDay;
                return;
            }
            if (currentDay > this.lastOverlayDayShown) {
                this.showNewDayMessage(client, currentDay, total);
                this.lastOverlayDayShown = currentDay;
            }
        }
    }

    private String buildPlainString(long total) {
        long day = total / 24000L;
        long dayTicks = total % 24000L;
        int hour = (int)((dayTicks / 1000L + 6L) % 24L);
        int minute = (int)(dayTicks % 1000L * 60L / 1000L);
        boolean caps = DcpClient.CONFIG.capitalizeText;
        StringBuilder sb = new StringBuilder(32);
        if (DcpClient.CONFIG.showDay) {
            String dayStr = this.formatDay(day);
            sb.append(caps ? "DAY " + dayStr : "Day " + dayStr);
        }
        if (DcpClient.CONFIG.showDay && DcpClient.CONFIG.showTime) {
            String sep = " ";
            if (DcpClient.CONFIG.showSeparator) {
                String candidate = DcpClient.CONFIG.separatorCharacter;
                if (candidate == null || candidate.isEmpty()) {
                    candidate = " - ";
                }
                sep = candidate;
            }
            sb.append(sep);
        }
        if (DcpClient.CONFIG.showTime) {
            String time = this.formatTime(hour, minute);
            sb.append(DcpClient.CONFIG.capitalizeText ? time.toUpperCase(Locale.ROOT) : time);
        }
        return sb.toString();
    }

    private class_5250 buildOverlayMessage(class_310 client, long total) {
        return this.buildOverlayMessage(client, total, false);
    }

    private class_5250 buildOverlayMessage(class_310 client, long total, boolean forceColorRecompute) {
        long day = total / 24000L;
        long dayTicks = total % 24000L;
        int hour = (int)((dayTicks / 1000L + 6L) % 24L);
        int minute = (int)(dayTicks % 1000L * 60L / 1000L);
        if (forceColorRecompute || this.colorCacheLastUpdatedTick == -1L) {
            int baseColor = DcpClient.CONFIG.dynamicColors ? this.getBiomeOrDimensionColor(client) : DcpClient.CONFIG.dayColor;
            Integer[] cachedDynamic = this.dynamicColorCache.get(baseColor);
            if (cachedDynamic != null && this.lastBaseColorChecked != null && this.lastBaseColorChecked.equals(baseColor)) {
                this.cachedDynamicColor = cachedDynamic[0];
                this.cachedDynamicSeparator = cachedDynamic[1];
            } else {
                this.cachedDynamicColor = DcpClient.lightenIfDark(baseColor, 1.2);
                this.cachedDynamicSeparator = DcpClient.darkenColor(this.cachedDynamicColor, 0.75);
                this.dynamicColorCache.put(baseColor, new Integer[]{this.cachedDynamicColor, this.cachedDynamicSeparator});
            }
            this.lastBaseColorChecked = baseColor;
            this.colorCacheLastUpdatedTick = total;
            this.lastMainTextColor = null;
            this.lastSeparatorTextColor = null;
        }
        if (this.lastMainTextColor == null || this.cachedDynamicColor != this.lastRenderedColor) {
            this.lastMainTextColor = class_5251.method_27717((int)this.cachedDynamicColor);
        }
        if (this.lastSeparatorTextColor == null || this.cachedDynamicSeparator != this.lastRenderedSeparator) {
            this.lastSeparatorTextColor = class_5251.method_27717((int)this.cachedDynamicSeparator);
        }
        String timeStr = this.formatTime(hour, minute);
        String dayStr = this.formatDay(day);
        boolean caps = DcpClient.CONFIG.capitalizeText;
        class_5250 msg = class_2561.method_43470((String)"");
        if (DcpClient.CONFIG.showDay) {
            String dayPart = caps ? "DAY " + dayStr : "Day " + dayStr;
            msg.method_10852((class_2561)class_2561.method_43470((String)dayPart).method_27694(s -> s.method_27703(this.lastMainTextColor)));
        }
        if (DcpClient.CONFIG.showDay && DcpClient.CONFIG.showTime) {
            String sep = " ";
            if (DcpClient.CONFIG.showSeparator) {
                String candidate = DcpClient.CONFIG.separatorCharacter;
                if (candidate == null || candidate.isEmpty()) {
                    candidate = " - ";
                }
                sep = candidate;
            }
            msg.method_10852((class_2561)class_2561.method_43470((String)sep).method_27694(s -> s.method_27703(this.lastSeparatorTextColor)));
        }
        if (DcpClient.CONFIG.showTime) {
            String timePart = caps ? timeStr.toUpperCase(Locale.ROOT) : timeStr;
            msg.method_10852((class_2561)class_2561.method_43470((String)timePart).method_27694(s -> s.method_27703(this.lastMainTextColor)));
        }
        return msg;
    }

    private static int lightenIfDark(int rgb, double factor) {
        double lum = DcpClient.luminance(rgb);
        if (lum < 140.0 || factor > 1.0) {
            return DcpClient.lightenColor(rgb, factor);
        }
        return rgb;
    }

    private static double luminance(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    private static int lightenColor(int rgb, double factor) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int nr = DcpClient.clamp((int)Math.round((double)r * factor));
        int ng = DcpClient.clamp((int)Math.round((double)g * factor));
        int nb = DcpClient.clamp((int)Math.round((double)b * factor));
        return nr << 16 | ng << 8 | nb;
    }

    private static int darkenColor(int rgb, double factor) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int nr = DcpClient.clamp((int)Math.round((double)r * factor));
        int ng = DcpClient.clamp((int)Math.round((double)g * factor));
        int nb = DcpClient.clamp((int)Math.round((double)b * factor));
        return nr << 16 | ng << 8 | nb;
    }

    private static int clamp(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    private int getBiomeOrDimensionColor(class_310 client) {
        if (client.field_1724 == null) {
            return DcpClient.CONFIG.dayColor;
        }
        return this.getBiomeOrDimensionColor(client, client.field_1724.method_24515(), true);
    }

    private int getBiomeOrDimensionColor(class_310 client, class_2338 currentPos, boolean playerMoved) {
        int fallback = DcpClient.CONFIG.dayColor;
        if (client.field_1724 == null || client.field_1687 == null) {
            return fallback;
        }
        try {
            try {
                String dimStr = client.field_1687.method_27983().method_29177().toString().toLowerCase(Locale.ROOT);
                if (dimStr.contains("the_end") || dimStr.contains("end")) {
                    return 13078471;
                }
                if (dimStr.contains("the_nether") || dimStr.contains("nether")) {
                    fallback = 8599353;
                }
            }
            catch (Throwable dimStr) {
                // empty catch block
            }
            String biomeId = null;
            try {
                class_6880 holder = client.field_1687.method_23753(currentPos);
                biomeId = holder.toString().toLowerCase(Locale.ROOT);
            }
            catch (Throwable holder) {
                // empty catch block
            }
            if (biomeId == null) {
                return fallback;
            }
            if (!playerMoved && this.lastBiomeSampledColor != -1) {
                if (currentPos.method_10264() < 58) {
                    if (biomeId.contains("deep_dark")) {
                        return 2225400;
                    }
                    if (biomeId.contains("dripstone_caves") || biomeId.contains("dripstone")) {
                        return 10390384;
                    }
                    if (biomeId.contains("lush_caves")) {
                        return 1285148;
                    }
                }
                return this.lastBiomeSampledColor;
            }
            int computedColor = -1;
            if (currentPos.method_10264() < 58) {
                int horizRays = 24;
                double[] pitchLevels = new double[]{-0.25, 0.0, 0.25};
                double maxDistance = 24.0;
                double step = 1.0;
                int earlyExitHits = 30;
                double eyeX = client.field_1724.method_23317();
                double eyeY = client.field_1724.method_23320();
                double eyeZ = client.field_1724.method_23321();
                HashMap<Integer, Integer> colorCount = new HashMap<Integer, Integer>();
                int hits = 0;
                block6: for (int i = 0; i < 24 && hits < 30; ++i) {
                    double yaw = Math.PI * 2 * (double)i / 24.0;
                    for (double pitch : pitchLevels) {
                        double cosPitch = Math.cos(pitch);
                        double dirX = cosPitch * Math.cos(yaw);
                        double dirY = Math.sin(pitch);
                        double dirZ = cosPitch * Math.sin(yaw);
                        for (double d = 1.0; d <= 24.0; d += 1.0) {
                            int bz;
                            int by;
                            double sx = eyeX + dirX * d;
                            double sy = eyeY + dirY * d;
                            double sz = eyeZ + dirZ * d;
                            int bx = (int)Math.floor(sx);
                            class_2338 samplePos = new class_2338(bx, by = (int)Math.floor(sy), bz = (int)Math.floor(sz));
                            class_2680 state = client.field_1687.method_8320(samplePos);
                            if (state == null || state.method_26215()) continue;
                            String blockName = state.method_26204().toString().toLowerCase(Locale.ROOT);
                            int color = blockName.contains("deepslate") ? 0x777777 : (blockName.contains("stone") ? 0x888888 : (blockName.contains("granite") ? 11754564 : (blockName.contains("diorite") ? 0xDADADA : (blockName.contains("andesite") ? 0xA0A0A0 : (blockName.contains("dirt") ? 9136971 : (blockName.contains("cobblestone") ? 0x777777 : (blockName.contains("bedrock") ? 0x4C4C4C : (blockName.contains("lava") ? 16729344 : (blockName.contains("water") ? 4159204 : (blockName.contains("gravel") ? 0x999999 : (blockName.contains("gold_ore") ? 16766720 : (blockName.contains("iron_ore") ? 14198618 : (blockName.contains("coal_ore") ? 0x222222 : (blockName.contains("tuff") ? 8157811 : (blockName.contains("sculk") ? 2225400 : (blockName.contains("amethyst") ? 10712812 : (blockName.contains("dripstone_block") ? 10390384 : (blockName.contains("moss") || blockName.contains("moss_block") ? 6784810 : 0xAAAAAA))))))))))))))))));
                            colorCount.put(color, colorCount.getOrDefault(color, 0) + 1);
                            ++hits;
                            break;
                        }
                        if (hits >= 30) continue block6;
                    }
                }
                if (!colorCount.isEmpty()) {
                    computedColor = (Integer)colorCount.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey();
                }
            }
            if (computedColor == -1) {
                for (Map.Entry<String, Integer> entry : BIOME_COLOR_MAP.entrySet()) {
                    if (!biomeId.contains(entry.getKey())) continue;
                    computedColor = entry.getValue();
                    break;
                }
            }
            this.lastBiomeSamplePos = currentPos;
            this.lastBiomeSampledColor = computedColor != -1 ? computedColor : fallback;
            return this.lastBiomeSampledColor;
        }
        catch (Throwable throwable) {
            this.lastBiomeSamplePos = currentPos;
            this.lastBiomeSampledColor = fallback;
            return fallback;
        }
    }

    private String formatTime(int hour, int minute) {
        if (DcpClient.CONFIG.timeFormat == DcpConfig.TimeFormat.H24) {
            String hourStr = (hour < 10 ? "0" : "") + hour;
            String minuteStr = (minute < 10 ? "0" : "") + minute;
            return hourStr + ":" + minuteStr;
        }
        int h12 = hour % 12 == 0 ? 12 : hour % 12;
        String ampm = hour >= 12 ? "PM" : "AM";
        String hourStr = (h12 < 10 ? "0" : "") + h12;
        String minuteStr = (minute < 10 ? "0" : "") + minute;
        return hourStr + ":" + minuteStr + " " + ampm;
    }

    private String formatDay(long day) {
        Locale locale = Locale.getDefault();
        if (this.cachedNumberFormat == null || this.lastNumberFormatMode != DcpClient.CONFIG.thousandSeparator || this.lastLocale != locale) {
            NumberFormat nf = NumberFormat.getIntegerInstance(locale);
            nf.setGroupingUsed(DcpClient.CONFIG.thousandSeparator != DcpConfig.ThousandSeparatorMode.NONE);
            this.cachedNumberFormat = nf;
            this.lastNumberFormatMode = DcpClient.CONFIG.thousandSeparator;
            this.lastLocale = locale;
        }
        String dayStr = this.cachedNumberFormat.format(day);
        if (DcpClient.CONFIG.thousandSeparator == DcpConfig.ThousandSeparatorMode.DOTS) {
            dayStr = dayStr.replace(',', '.');
        } else if (DcpClient.CONFIG.thousandSeparator == DcpConfig.ThousandSeparatorMode.COMMAS && !dayStr.contains(",")) {
            dayStr = dayStr.replace('.', ',');
        }
        return dayStr;
    }

    private void showNewDayMessage(class_310 client, long day, long totalTicksNow) {
        int dynamicSeparator;
        int dynamicColor;
        int baseColor = DcpClient.CONFIG.dynamicColors ? this.getBiomeOrDimensionColor(client) : DcpClient.CONFIG.dayColor;
        Integer[] cachedDynamic = this.dynamicColorCache.get(baseColor);
        if (cachedDynamic != null) {
            dynamicColor = cachedDynamic[0];
            dynamicSeparator = cachedDynamic[1];
        } else {
            dynamicColor = DcpClient.lightenIfDark(baseColor, 1.2);
            dynamicSeparator = DcpClient.darkenColor(dynamicColor, 0.75);
            this.dynamicColorCache.put(baseColor, new Integer[]{dynamicColor, dynamicSeparator});
        }
        Function<String, String> cap = s -> DcpClient.CONFIG.capitalizeText ? s.toUpperCase(Locale.ROOT) : s;
        String dayStr = this.formatDay(day);
        long dayTicks = totalTicksNow % 24000L;
        int hour = (int)((dayTicks / 1000L + 6L) % 24L);
        int minute = (int)(dayTicks % 1000L * 60L / 1000L);
        String timeStr = this.formatTime(hour, minute);
        class_5251 mainColor = class_5251.method_27717((int)dynamicColor);
        class_5251 sepColor = class_5251.method_27717((int)dynamicSeparator);
        class_5250 msg = class_2561.method_43470((String)"");
        if (DcpClient.CONFIG.showDay) {
            msg.method_10852((class_2561)class_2561.method_43470((String)cap.apply("Day " + dayStr)).method_27694(s -> s.method_27703(mainColor)));
        }
        if (DcpClient.CONFIG.showDay && DcpClient.CONFIG.showTime) {
            String sep = " ";
            if (DcpClient.CONFIG.showSeparator) {
                String candidate = DcpClient.CONFIG.separatorCharacter;
                if (candidate == null || candidate.isEmpty()) {
                    candidate = " - ";
                }
                sep = candidate;
            }
            msg.method_10852((class_2561)class_2561.method_43470((String)sep).method_27694(s -> s.method_27703(sepColor)));
        }
        if (DcpClient.CONFIG.showTime) {
            msg.method_10852((class_2561)class_2561.method_43470((String)cap.apply(timeStr)).method_27694(s -> s.method_27703(mainColor)));
        }
        if (client.field_1705 != null) {
            client.field_1705.method_1758((class_2561)msg, false);
        }
    }

    private void playConfiguredSound(class_310 client) {
        if (client.field_1724 == null || !DcpClient.CONFIG.enableNewDaySound) {
            return;
        }
        String raw = DcpClient.CONFIG.newDaySoundId;
        if (raw == null || raw.trim().isEmpty()) {
            client.field_1724.method_5783(class_3417.field_14891, 1.0f, 1.0f);
            return;
        }
        String normalized = raw.trim().toLowerCase(Locale.ROOT);
        try {
            Optional<class_3414> opt;
            class_2960 id = class_2960.method_12829((String)normalized);
            if (id != null && (opt = class_7923.field_41172.method_10223(id).map(class_6880.class_6883::comp_349)).isPresent()) {
                class_3414 soundEvent = opt.get();
                try {
                    client.field_1724.method_5783(soundEvent, 1.0f, 1.0f);
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)1.0f, (float)1.0f));
                        return;
                    }
                    catch (Throwable throwable2) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        client.field_1724.method_5783(class_3417.field_14891, 1.0f, 1.0f);
    }

    private void playToggleSound(class_310 client, class_3414 soundToPlay) {
        if (client.field_1724 == null) {
            return;
        }
        try {
            if (this.lastToggleSound != null) {
                client.method_1483().method_4870((class_1113)this.lastToggleSound);
            }
            this.lastToggleSound = class_1109.method_4757((class_3414)soundToPlay, (float)1.0f, (float)1.0f);
            client.method_1483().method_4873((class_1113)this.lastToggleSound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        BIOME_COLOR_MAP = Map.ofEntries(Map.entry("nether_wastes", 8599353), Map.entry("crimson_forest", 13182502), Map.entry("warped_forest", 1742238), Map.entry("soul_sand_valley", 7033154), Map.entry("soul_sand", 7033154), Map.entry("basalt_deltas", 0x555555), Map.entry("the_end", 15396784), Map.entry("end_midlands", 14202602), Map.entry("end_highlands", 14202602), Map.entry("end_barrens", 14202602), Map.entry("small_end_islands", 15396784), Map.entry("end_islands", 15396784), Map.entry("warm_ocean", 0x5BF5FF), Map.entry("lukewarm_ocean", 7395581), Map.entry("cold_ocean", 2186659), Map.entry("frozen_ocean", 8310269), Map.entry("deep_warm_ocean", 870571), Map.entry("deep_lukewarm_ocean", 870571), Map.entry("deep_ocean", 870571), Map.entry("deep_cold_ocean", 870571), Map.entry("deep_frozen_ocean", 870571), Map.entry("ocean", 3581155), Map.entry("snowy_beach", 15330799), Map.entry("stony_shore", 0x9E9E9E), Map.entry("beach", 15848335), Map.entry("river", 5022681), Map.entry("mushroom", 8608402), Map.entry("jagged_peaks", 0xA5A5A5), Map.entry("frozen_peaks", 15134968), Map.entry("stony_peaks", 0xB7B7B7), Map.entry("snowy_slopes", 0xEDEDED), Map.entry("windswept_hills", 9086896), Map.entry("windswept_savanna", 15585426), Map.entry("windswept", 9086896), Map.entry("meadow", 11069135), Map.entry("cherry_grove", 15972312), Map.entry("grove", 0x7AA37A), Map.entry("flower_forest", 13889752), Map.entry("dark_forest", 16384), Map.entry("birch_forest", 10998684), Map.entry("old_growth_birch", 7314287), Map.entry("old_growth_pine", 7314287), Map.entry("old_growth", 7314287), Map.entry("forest", 5025616), Map.entry("pale_garden", 0x888888), Map.entry("snowy_taiga", 13627383), Map.entry("taiga", 3050327), Map.entry("bamboo_jungle", 3120708), Map.entry("sparse_jungle", 3781962), Map.entry("jungle", 2074944), Map.entry("mangrove_swamp", 3581072), Map.entry("swamp", 6588503), Map.entry("sunflower_plains", 16179834), Map.entry("plains", 0xCFFFBF), Map.entry("desert", 16775350), Map.entry("savanna_plateau", 15585426), Map.entry("savanna", 15585426), Map.entry("badlands_eroded", 16743763), Map.entry("eroded_badlands", 16743763), Map.entry("wooded_badlands", 13860150), Map.entry("badlands", 14962705), Map.entry("snowy_plains", 15398655), Map.entry("ice_spikes", 15398655));
    }
}

