/*
 * Decompiled with CFR 0.152.
 */
package com.smm.dcp.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class DcpConfig {
    public boolean enabled = true;
    public boolean showDay = true;
    public boolean showTime = true;
    public ThousandSeparatorMode thousandSeparator = ThousandSeparatorMode.COMMAS;
    public TimeFormat timeFormat = TimeFormat.H24;
    public boolean enableOnSingleplayer = true;
    public boolean enableOnMultiplayer = true;
    public boolean capitalizeText = false;
    public boolean onlyShowOnNewDay = false;
    public boolean showSeparator = true;
    public String separatorCharacter = " - ";
    public boolean enableNewDaySound = true;
    public String newDaySoundId = "minecraft:block.beacon.power_select";
    public boolean playToggleVisibilitySound = true;
    public int dayColor = 0xFFFFFF;
    public int timeColor = 0xFFFFFF;
    public int separatorColor = 0xAAAAAA;
    public boolean dynamicColors = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/dcp.json");

    public static DcpConfig load() {
        DcpConfig dcpConfig;
        if (!CONFIG_FILE.exists()) {
            DcpConfig defaultConfig = new DcpConfig();
            defaultConfig.save();
            return defaultConfig;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            dcpConfig = (DcpConfig)GSON.fromJson((Reader)reader, DcpConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new DcpConfig();
            }
        }
        reader.close();
        return dcpConfig;
    }

    public void save() {
        try {
            File parent = CONFIG_FILE.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ThousandSeparatorMode {
        NONE("No"),
        COMMAS("Commas"),
        DOTS("Dots");

        private final String label;

        private ThousandSeparatorMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TimeFormat {
        H24("24h"),
        H12("12h");

        private final String label;

        private TimeFormat(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

