/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.teamck.villagerEnchantTracker.Database;
import org.teamck.villagerEnchantTracker.MessageManager;
import org.teamck.villagerEnchantTracker.ParticleManager;
import org.teamck.villagerEnchantTracker.Trade;
import org.teamck.villagerEnchantTracker.VillagerRegion;

public class FindVillagerCommand
implements CommandExecutor,
TabCompleter {
    private final MessageManager messageManager;
    private final JavaPlugin plugin;
    private final ParticleManager particleManager;
    private final Database db;

    public FindVillagerCommand(MessageManager messageManager, JavaPlugin plugin, Database db) {
        this.messageManager = messageManager;
        this.plugin = plugin;
        this.particleManager = new ParticleManager(plugin);
        this.db = db;
    }

    public List<Trade> searchNearbyVillagerTrades(Player player, String enchantId, double radius) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (Entity entity : player.getNearbyEntities(radius, radius, radius)) {
            if (!(entity instanceof Villager)) continue;
            Villager villager = (Villager)entity;
            for (MerchantRecipe recipe : villager.getRecipes()) {
                ItemMeta itemMeta;
                ItemStack result = recipe.getResult();
                if (result.getType() != Material.ENCHANTED_BOOK || !((itemMeta = result.getItemMeta()) instanceof EnchantmentStorageMeta)) continue;
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
                meta.getStoredEnchants().forEach((enchant, level) -> {
                    if (("minecraft:" + enchant.getKey().getKey()).equals(enchantId)) {
                        int price = recipe.getIngredients().stream().filter(i -> i.getType() == Material.EMERALD).mapToInt(ItemStack::getAmount).sum();
                        this.plugin.getLogger().info("Checking if villager is in any region");
                        String regionName = null;
                        for (VillagerRegion region : this.db.listRegions()) {
                            this.plugin.getLogger().info("Region: " + region.getName() + " " + String.valueOf(region.getMin()) + " " + String.valueOf(region.getMax()));
                            this.plugin.getLogger().info("Villager Location: " + String.valueOf(villager.getLocation()));
                            if (!region.contains(villager.getLocation())) continue;
                            this.plugin.getLogger().info("Region found: " + region.getName());
                            regionName = region.getName();
                            break;
                        }
                        this.plugin.getLogger().info("RegionName: " + regionName);
                        trades.add(new Trade(0, enchantId, (int)level, price, villager.getLocation(), "", regionName));
                    }
                });
            }
        }
        return trades;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.getChatMessage("player_only"));
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("villagerenchanttracker.find")) {
            sender.sendMessage(this.messageManager.getChatMessage("no_permission"));
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(this.messageManager.getChatMessage("findvillager_usage"));
            return true;
        }
        if (args[0].equalsIgnoreCase("particle")) {
            this.particleManager.handleParticleCommand(player, args);
            return true;
        }
        String searchTerm = String.join((CharSequence)" ", args);
        String enchantId = this.messageManager.getEnchantIdFromLocalName(searchTerm, this.messageManager.getBaseLanguageCode(player.getLocale()));
        if (enchantId == null) {
            player.sendMessage(this.messageManager.getChatMessage("invalid_enchant"));
            return true;
        }
        this.particleManager.cancelAllParticles(player);
        double radius = 50.0;
        List<Trade> trades = this.searchNearbyVillagerTrades(player, enchantId, radius);
        if (trades.isEmpty()) {
            player.sendMessage(this.messageManager.getChatMessage("no_found_trades"));
            return true;
        }
        for (Trade trade : trades) {
            String localName = this.messageManager.getEnchantName(enchantId, this.messageManager.getBaseLanguageCode(player.getLocale()));
            Location loc = trade.getLocation();
            String message = this.messageManager.format("found_trade_info", localName, trade.getLevel(), trade.getPrice(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), trade.getRegionName());
            TextComponent textComponent = this.messageManager.createClickableMessage(message, loc, "/findvillager particle");
            player.spigot().sendMessage((BaseComponent)textComponent);
            this.particleManager.spawnParticles(loc, player, false);
            this.particleManager.drawLine(player.getLocation(), loc, player, false);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player player;
        block5: {
            block4: {
                if (!(sender instanceof Player)) break block4;
                player = (Player)sender;
                if (sender.hasPermission("villagerenchanttracker.find")) break block5;
            }
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return this.messageManager.getEnchantNames(this.messageManager.getBaseLanguageCode(player.getLocale())).stream().filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

