/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.plugin.java.JavaPlugin;
import org.teamck.villagerEnchantTracker.Database;
import org.teamck.villagerEnchantTracker.MessageManager;
import org.teamck.villagerEnchantTracker.ParticleManager;
import org.teamck.villagerEnchantTracker.Trade;

public class LibrarianDBCommand
implements CommandExecutor,
TabCompleter {
    private final Database db;
    private final MessageManager messageManager;
    private final JavaPlugin plugin;
    private final ParticleManager particleManager;
    private static final List<String> SUBCOMMANDS = Arrays.asList("create", "search", "list", "delete", "edit-description", "particle");

    public LibrarianDBCommand(Database db, MessageManager messageManager, JavaPlugin plugin) {
        this.db = db;
        this.messageManager = messageManager;
        this.plugin = plugin;
        this.particleManager = new ParticleManager(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        block21: {
            block20: {
                if (!(sender instanceof Player)) break block20;
                player = (Player)sender;
                if (sender.hasPermission("villagerenchanttracker.admin")) break block21;
            }
            sender.sendMessage(this.messageManager.getChatMessage("no_permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.messageManager.getChatMessage("usage"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "search": {
                this.handleSearch(player, args);
                break;
            }
            case "list": {
                this.handleList(player, args);
                break;
            }
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            case "edit-description": {
                this.handleEditDescription(player, args);
                break;
            }
            case "particle": {
                this.handleParticle(player, args);
                break;
            }
            default: {
                sender.sendMessage(this.messageManager.getChatMessage("invalid_subcommand"));
            }
        }
        return true;
    }

    private void handleCreate(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messageManager.getChatMessage("create_usage"));
            return;
        }
        Entity target = player.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(e -> e instanceof Villager).min(Comparator.comparingDouble(e -> e.getLocation().distanceSquared(player.getLocation()))).orElse(null);
        if (!(target instanceof Villager)) {
            player.sendMessage(this.messageManager.getChatMessage("no_villager_nearby"));
            return;
        }
        Villager villager = (Villager)target;
        String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        boolean tradesAdded = this.db.addVillagerTrades(villager, description);
        if (tradesAdded) {
            player.sendMessage(this.messageManager.getChatMessage("villager_trades_registered"));
        } else {
            player.sendMessage(this.messageManager.getChatMessage("no_enchant_trades"));
        }
    }

    private void handleSearch(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messageManager.getChatMessage("search_usage"));
            return;
        }
        String searchTerm = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String enchantId = this.messageManager.getEnchantIdFromLocalName(searchTerm, this.messageManager.getBaseLanguageCode(player.getLocale()));
        if (enchantId == null) {
            player.sendMessage(this.messageManager.getChatMessage("invalid_enchant"));
            return;
        }
        this.particleManager.cancelAllParticles(player);
        List<Trade> trades = this.db.searchTrades(enchantId);
        if (trades.isEmpty()) {
            player.sendMessage(this.messageManager.getChatMessage("no_found_trades"));
            return;
        }
        for (Trade trade : trades) {
            String localName = this.messageManager.getEnchantName(enchantId, this.messageManager.getBaseLanguageCode(player.getLocale()));
            Location loc = trade.getLocation();
            String message = this.messageManager.format("found_trade_info", localName, trade.getLevel(), trade.getPrice(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), trade.getRegionName());
            TextComponent textComponent = this.messageManager.createClickableMessage(message, loc, "/librariandb particle");
            player.spigot().sendMessage((BaseComponent)textComponent);
            this.particleManager.spawnParticles(loc, player, false);
        }
    }

    private void handleList(Player player, String[] args) {
        List<Trade> trades = this.db.listTrades();
        if (trades.isEmpty()) {
            player.sendMessage(this.messageManager.getChatMessage("no_trades"));
            return;
        }
        String baseLanguage = this.messageManager.getBaseLanguageCode(player.getLocale());
        player.sendMessage(this.messageManager.getChatMessage("trade_list_header"));
        for (Trade trade : trades) {
            String localName = this.messageManager.getEnchantName(trade.getEnchantId(), baseLanguage);
            Location loc = trade.getLocation();
            String message = this.messageManager.format("trade_list_entry", trade.getId(), localName, trade.getLevel(), trade.getPrice(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), trade.getDescription());
            TextComponent textComponent = this.messageManager.createClickableMessage(message, loc, "/librariandb particle");
            player.spigot().sendMessage((BaseComponent)textComponent);
        }
    }

    private void handleDelete(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messageManager.getChatMessage("delete_usage"));
            return;
        }
        try {
            int id = Integer.parseInt(args[1]);
            this.db.deleteTrade(id);
            player.sendMessage(this.messageManager.getChatMessage("trade_deleted"));
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.messageManager.getChatMessage("id_must_be_number"));
        }
    }

    private void handleEditDescription(Player player, String[] args) {
        if (args.length < 3) {
            player.sendMessage(this.messageManager.getChatMessage("edit_description_usage"));
            return;
        }
        try {
            int id = Integer.parseInt(args[1]);
            String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            boolean success = this.db.updateTradeDescription(id, description);
            if (success) {
                player.sendMessage(this.messageManager.getChatMessage("description_updated"));
            } else {
                player.sendMessage(this.messageManager.getChatMessage("trade_not_found"));
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.messageManager.getChatMessage("id_must_be_number"));
        }
    }

    private void handleParticle(Player player, String[] args) {
        this.particleManager.handleParticleCommand(player, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return SUBCOMMANDS.stream().filter(s -> !s.equals("particle") && s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return null;
    }
}

