/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.teamck.villagerEnchantTracker.EnchantManager;

public class MessageManager {
    private static MessageManager instance;
    private final JavaPlugin plugin;
    private final Map<String, YamlConfiguration> messages;
    private String chatLanguage;
    private static final String DEFAULT_VERSION = "0.1.0";

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.messages = new HashMap<String, YamlConfiguration>();
        instance = this;
        this.loadLanguages();
    }

    public static MessageManager getInstance() {
        return instance;
    }

    private void loadLanguages() {
        this.chatLanguage = this.plugin.getConfig().getString("language.chat", "en");
        File localizationDir = new File(this.plugin.getDataFolder(), "localization");
        if (!localizationDir.exists()) {
            localizationDir.mkdirs();
        }
        this.checkConfigVersion((YamlConfiguration)this.plugin.getConfig(), "config.yml");
        for (String lang : new String[]{"en", "ko"}) {
            File langFile = new File(localizationDir, lang + ".yml");
            if (!langFile.exists()) {
                this.plugin.saveResource("localization/" + lang + ".yml", false);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            this.messages.put(lang, config);
            this.checkConfigVersion(config, lang + ".yml");
        }
    }

    private void checkConfigVersion(YamlConfiguration config, String fileName) {
        String pluginVersion;
        String fileVersion = config.getString("version", DEFAULT_VERSION);
        if (!fileVersion.equals(pluginVersion = this.plugin.getDescription().getVersion())) {
            this.plugin.getLogger().warning("Version mismatch in " + fileName + ": File version is " + fileVersion + " but plugin version is " + pluginVersion);
        }
    }

    public String getMessage(String key, String language) {
        YamlConfiguration config = this.messages.get(language);
        if (config == null) {
            config = this.messages.get("en");
        }
        return config.getString(key, key);
    }

    public String getChatMessage(String key) {
        return this.getMessage(key, this.chatLanguage);
    }

    public String format(String key, Object ... args) {
        String message = this.getChatMessage(key);
        return String.format(message, args);
    }

    public String getEnchantName(String enchantId, String language) {
        String key = enchantId;
        if (key.startsWith("minecraft:")) {
            key = key.substring("minecraft:".length());
        }
        return this.getMessage("enchantments." + key, language);
    }

    public String getLocalEnchantName(String enchantId) {
        return this.getEnchantName(enchantId, this.chatLanguage);
    }

    public String getBaseLanguageCode(String fullLocale) {
        return fullLocale.split("_")[0];
    }

    public String getEnchantIdFromLocalName(String localName, String language) {
        this.plugin.getLogger().info("Searching for enchantment ID for name: " + localName + " in language: " + language);
        String baseLanguage = this.getBaseLanguageCode(language);
        YamlConfiguration config = this.messages.get(baseLanguage);
        if (config == null) {
            this.plugin.getLogger().info("Language " + baseLanguage + " not found, using English");
            config = this.messages.get("en");
        }
        if (config.contains("enchantments")) {
            this.plugin.getLogger().info("Found enchantments section in config");
            for (String key : config.getConfigurationSection("enchantments").getKeys(false)) {
                String value = config.getString("enchantments." + key);
                this.plugin.getLogger().info("Checking key: " + key + " with value: " + value);
                if (value == null || !value.equals(localName)) continue;
                this.plugin.getLogger().info("Found matching enchantment: " + key);
                return "minecraft:" + key;
            }
        } else {
            this.plugin.getLogger().info("No enchantments section found in config");
        }
        Object enchantId = localName;
        if (((String)enchantId).startsWith("enchantments.")) {
            enchantId = ((String)enchantId).substring("enchantments.".length());
        }
        if (!((String)enchantId).startsWith("minecraft:")) {
            enchantId = "minecraft:" + (String)enchantId;
        }
        if (EnchantManager.getEnchant((String)enchantId) != null) {
            this.plugin.getLogger().info("Found valid enchantment ID: " + (String)enchantId);
            return enchantId;
        }
        this.plugin.getLogger().info("No matching enchantment found");
        return null;
    }

    public List<String> getEnchantNames(String language) {
        ArrayList<String> names = new ArrayList<String>();
        String baseLanguage = this.getBaseLanguageCode(language);
        YamlConfiguration config = this.messages.get(baseLanguage);
        if (config == null) {
            config = this.messages.get("en");
        }
        if (config.contains("enchantments")) {
            for (String key : config.getConfigurationSection("enchantments").getKeys(false)) {
                String value = config.getString("enchantments." + key);
                if (value == null) continue;
                names.add(value);
            }
        }
        return names;
    }

    public TextComponent createClickableMessage(String message, Location loc, String command) {
        TextComponent textComponent = new TextComponent(message);
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ()));
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.getChatMessage("click_to_show_particles"))}));
        return textComponent;
    }
}

