/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class ParticleManager {
    private final JavaPlugin plugin;
    private final Map<Player, Set<BukkitTask>> activeTasks;
    private final Map<Player, Location> lineEndpoints;

    public ParticleManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.activeTasks = new HashMap<Player, Set<BukkitTask>>();
        this.lineEndpoints = new HashMap<Player, Location>();
    }

    public void cancelAllParticles(Player player) {
        Set<BukkitTask> tasks = this.activeTasks.get(player);
        if (tasks != null) {
            for (BukkitTask task : tasks) {
                if (task == null || task.isCancelled()) continue;
                task.cancel();
            }
            tasks.clear();
            this.activeTasks.remove(player);
        }
        this.lineEndpoints.remove(player);
    }

    private void removeTask(Player player, BukkitTask task) {
        Set<BukkitTask> tasks = this.activeTasks.get(player);
        if (tasks != null) {
            tasks.remove(task);
            if (tasks.isEmpty()) {
                this.activeTasks.remove(player);
            }
        }
    }

    public void spawnParticles(Location loc, Player player, boolean cancelExisting) {
        if (cancelExisting) {
            this.cancelAllParticles(player);
        }
        if (!this.plugin.getConfig().getBoolean("particle-effects.show-pillar", true)) {
            return;
        }
        List particleConfigs = this.plugin.getConfig().getMapList("particles");
        int duration = this.plugin.getConfig().getInt("particle-duration", 30);
        int interval = this.plugin.getConfig().getInt("particle-interval", 1);
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Map particleConfig : particleConfigs) {
                String type = (String)particleConfig.get("type");
                int height = (Integer)particleConfig.get("height");
                int count = (Integer)particleConfig.get("count");
                try {
                    Particle particle = Particle.valueOf((String)type);
                    for (int y = 0; y <= height; ++y) {
                        Location particleLoc = loc.clone().add(0.0, (double)y, 0.0);
                        double offsetX = (Math.random() - 0.5) * 0.5;
                        double offsetY = (Math.random() - 0.5) * 0.5;
                        double offsetZ = (Math.random() - 0.5) * 0.5;
                        double speed = Math.random() * 0.1;
                        player.spawnParticle(particle, particleLoc, count, offsetX, offsetY, offsetZ, speed);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Wrong Particle Type: " + type);
                }
            }
        }, 0L, (long)interval * 20L);
        this.activeTasks.computeIfAbsent(player, k -> new HashSet()).add(task);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
            this.removeTask(player, task);
        }, (long)duration * 20L);
    }

    public void drawLine(Location start, Location end, Player player, boolean cancelExisting) {
        if (cancelExisting) {
            this.cancelAllParticles(player);
        }
        if (!this.plugin.getConfig().getBoolean("particle-effects.show-line", true)) {
            return;
        }
        this.lineEndpoints.put(player, end);
        int duration = this.plugin.getConfig().getInt("particle-duration", 30);
        double lineUpdateInterval = this.plugin.getConfig().getDouble("particle-effects.line-update-interval", 0.1);
        int points = this.plugin.getConfig().getInt("particle-effects.line-points", 20);
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            Location currentStart = player.getLocation();
            Location currentEnd = this.lineEndpoints.get(player);
            if (currentEnd == null) {
                return;
            }
            for (int i = 0; i <= points; ++i) {
                double ratio = (double)i / (double)points;
                double x = currentStart.getX() + (currentEnd.getX() - currentStart.getX()) * ratio;
                double y = currentStart.getY() + (currentEnd.getY() - currentStart.getY()) * ratio;
                double z = currentStart.getZ() + (currentEnd.getZ() - currentStart.getZ()) * ratio;
                Location particleLoc = new Location(currentStart.getWorld(), x, y, z);
                player.spawnParticle(Particle.END_ROD, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }, 0L, (long)(lineUpdateInterval * 20.0));
        this.activeTasks.computeIfAbsent(player, k -> new HashSet()).add(task);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
            this.removeTask(player, task);
            this.lineEndpoints.remove(player);
        }, (long)duration * 20L);
    }

    public void handleParticleCommand(Player player, String[] args) {
        if (args.length < 4) {
            return;
        }
        try {
            int x = Integer.parseInt(args[1]);
            int y = Integer.parseInt(args[2]);
            int z = Integer.parseInt(args[3]);
            Location loc = new Location(player.getWorld(), (double)x, (double)y, (double)z);
            this.spawnParticles(loc, player, true);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

