/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.teamck.villagerEnchantTracker.Database;
import org.teamck.villagerEnchantTracker.MessageManager;
import org.teamck.villagerEnchantTracker.VillagerRegion;

public class RegionCommand
implements CommandExecutor,
TabCompleter {
    private final Database db;
    private final MessageManager messageManager;
    private final JavaPlugin plugin;
    private static final List<String> SUBCOMMANDS = Arrays.asList("create", "list", "delete");

    public RegionCommand(Database db, MessageManager messageManager, JavaPlugin plugin) {
        this.db = db;
        this.messageManager = messageManager;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        block15: {
            block14: {
                if (!(sender instanceof Player)) break block14;
                player = (Player)sender;
                if (sender.hasPermission("villagerenchanttracker.admin")) break block15;
            }
            sender.sendMessage(this.messageManager.getChatMessage("no_permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.messageManager.getChatMessage("region_usage"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            default: {
                sender.sendMessage(this.messageManager.getChatMessage("invalid_subcommand"));
            }
        }
        return true;
    }

    private void handleCreate(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messageManager.getChatMessage("region_create_usage"));
            return;
        }
        WorldEditPlugin worldEdit = (WorldEditPlugin)this.plugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (worldEdit != null) {
            try {
                Region selection = worldEdit.getSession(player).getSelection(BukkitAdapter.adapt((World)player.getWorld()));
                if (selection != null) {
                    Location maxLoc;
                    String name = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                    BlockVector3 min = selection.getMinimumPoint();
                    BlockVector3 max = selection.getMaximumPoint();
                    Location minLoc = new Location(player.getWorld(), (double)min.getX(), (double)min.getY(), (double)min.getZ());
                    int regionId = this.db.createRegion(name, minLoc, maxLoc = new Location(player.getWorld(), (double)max.getX(), (double)max.getY(), (double)max.getZ()));
                    if (regionId != -1) {
                        player.sendMessage(this.messageManager.format("region_created", name));
                    } else {
                        player.sendMessage(this.messageManager.getChatMessage("region_creation_failed"));
                    }
                    return;
                }
            }
            catch (IncompleteRegionException e) {
                player.sendMessage(this.messageManager.getChatMessage("incomplete_selection"));
                return;
            }
        }
        if (args.length < 8) {
            player.sendMessage(this.messageManager.getChatMessage("region_create_coords_usage"));
            return;
        }
        try {
            String name = args[1];
            int x1 = Integer.parseInt(args[2]);
            int y1 = Integer.parseInt(args[3]);
            int z1 = Integer.parseInt(args[4]);
            int x2 = Integer.parseInt(args[5]);
            int y2 = Integer.parseInt(args[6]);
            int z2 = Integer.parseInt(args[7]);
            Location minLoc = new Location(player.getWorld(), (double)Math.min(x1, x2), (double)Math.min(y1, y2), (double)Math.min(z1, z2));
            Location maxLoc = new Location(player.getWorld(), (double)Math.max(x1, x2), (double)Math.max(y1, y2), (double)Math.max(z1, z2));
            int regionId = this.db.createRegion(name, minLoc, maxLoc);
            if (regionId != -1) {
                player.sendMessage(this.messageManager.format("region_created", name));
            } else {
                player.sendMessage(this.messageManager.getChatMessage("region_creation_failed"));
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.messageManager.getChatMessage("invalid_coordinates"));
        }
    }

    private void handleList(Player player) {
        List<VillagerRegion> regions = this.db.listRegions();
        if (regions.isEmpty()) {
            player.sendMessage(this.messageManager.getChatMessage("no_regions"));
            return;
        }
        player.sendMessage(this.messageManager.getChatMessage("region_list_header"));
        for (VillagerRegion region : regions) {
            String message = this.messageManager.format("region_list_entry", region.getId(), region.getName(), region.getMin().getBlockX(), region.getMin().getBlockY(), region.getMin().getBlockZ(), region.getMax().getBlockX(), region.getMax().getBlockY(), region.getMax().getBlockZ());
            player.sendMessage(message);
        }
    }

    private void handleDelete(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messageManager.getChatMessage("region_delete_usage"));
            return;
        }
        try {
            int id = Integer.parseInt(args[1]);
            this.db.deleteRegion(id);
            player.sendMessage(this.messageManager.getChatMessage("region_deleted"));
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.messageManager.getChatMessage("id_must_be_number"));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return SUBCOMMANDS.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return null;
    }
}

