/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.teamck.villagerEnchantTracker.Database;
import org.teamck.villagerEnchantTracker.Trade;
import org.teamck.villagerEnchantTracker.VillagerRegion;

public class SQLiteDatabase
implements Database {
    final Connection connection;

    public SQLiteDatabase(JavaPlugin plugin) throws SQLException {
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(plugin.getDataFolder()) + "/enchants.db");
        this.init();
    }

    @Override
    public void init() {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("    CREATE TABLE IF NOT EXISTS Regions (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        name TEXT UNIQUE NOT NULL,\n        min_x REAL NOT NULL,\n        min_y REAL NOT NULL,\n        min_z REAL NOT NULL,\n        max_x REAL NOT NULL,\n        max_y REAL NOT NULL,\n        max_z REAL NOT NULL,\n        world_name TEXT NOT NULL\n    )\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS Trades (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        enchant_id_string TEXT,\n        level INTEGER,\n        price INTEGER,\n        location TEXT,\n        description TEXT\n    )\n");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createTrade(String enchantId, int level, int price, Location location, String description) {
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO Trades (enchant_id_string, level, price, location, description) VALUES (?, ?, ?, ?, ?)");){
            stmt.setString(1, enchantId);
            stmt.setInt(2, level);
            stmt.setInt(3, price);
            stmt.setString(4, location.getX() + "," + location.getY() + "," + location.getZ());
            stmt.setString(5, description);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addVillagerTrades(Villager villager, String description) {
        boolean hasEnchantTrades = false;
        for (MerchantRecipe recipe : villager.getRecipes()) {
            ItemMeta itemMeta;
            ItemStack result = recipe.getResult();
            if (result.getType() != Material.ENCHANTED_BOOK || !((itemMeta = result.getItemMeta()) instanceof EnchantmentStorageMeta)) continue;
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
            hasEnchantTrades = true;
            meta.getStoredEnchants().forEach((enchant, level) -> {
                int price = recipe.getIngredients().stream().filter(i -> i.getType() == Material.EMERALD).mapToInt(ItemStack::getAmount).sum();
                this.createTrade("minecraft:" + enchant.getKey().getKey(), (int)level, price, villager.getLocation(), description);
            });
        }
        return hasEnchantTrades;
    }

    @Override
    public List<Trade> searchTrades(String enchantId) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM Trades WHERE enchant_id_string = ?");){
            stmt.setString(1, enchantId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String[] locParts = rs.getString("location").split(",");
                Location loc = new Location((World)Bukkit.getWorlds().get(0), Double.parseDouble(locParts[0]), Double.parseDouble(locParts[1]), Double.parseDouble(locParts[2]));
                String regionName = null;
                for (VillagerRegion region : this.listRegions()) {
                    if (!region.getWorld().equals((Object)loc.getWorld()) || !region.contains(loc)) continue;
                    regionName = region.getName();
                    break;
                }
                trades.add(new Trade(rs.getInt("id"), rs.getString("enchant_id_string"), rs.getInt("level"), rs.getInt("price"), loc, rs.getString("description"), regionName));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return trades;
    }

    @Override
    public List<Trade> listTrades() {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM Trades");){
            while (rs.next()) {
                String[] locParts = rs.getString("location").split(",");
                Location loc = new Location((World)Bukkit.getWorlds().get(0), Double.parseDouble(locParts[0]), Double.parseDouble(locParts[1]), Double.parseDouble(locParts[2]));
                String regionName = null;
                for (VillagerRegion region : this.listRegions()) {
                    if (!region.getWorld().equals((Object)loc.getWorld()) || !region.contains(loc)) continue;
                    regionName = region.getName();
                    break;
                }
                trades.add(new Trade(rs.getInt("id"), rs.getString("enchant_id_string"), rs.getInt("level"), rs.getInt("price"), loc, rs.getString("description"), regionName));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return trades;
    }

    @Override
    public void deleteTrade(int id) {
        try (PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM Trades WHERE id = ?");){
            stmt.setInt(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean updateTradeDescription(int id, String description) {
        boolean bl;
        block8: {
            PreparedStatement stmt = this.connection.prepareStatement("UPDATE Trades SET description = ? WHERE id = ?");
            try {
                stmt.setString(1, description);
                stmt.setInt(2, id);
                int rowsAffected = stmt.executeUpdate();
                boolean bl2 = bl = rowsAffected > 0;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int createRegion(String name, Location min, Location max) {
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO Regions (name, min_x, min_y, min_z, max_x, max_y, max_z, world_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", 1);){
            stmt.setString(1, name);
            stmt.setDouble(2, min.getX());
            stmt.setDouble(3, min.getY());
            stmt.setDouble(4, min.getZ());
            stmt.setDouble(5, max.getX());
            stmt.setDouble(6, max.getY());
            stmt.setDouble(7, max.getZ());
            stmt.setString(8, min.getWorld().getName());
            stmt.executeUpdate();
            ResultSet rs = stmt.getGeneratedKeys();
            if (!rs.next()) return -1;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    @Override
    public void deleteRegion(int id) {
        try (PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM Regions WHERE id = ?");){
            stmt.setInt(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<VillagerRegion> listRegions() {
        ArrayList<VillagerRegion> regions = new ArrayList<VillagerRegion>();
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM Regions");){
            while (rs.next()) {
                Location min = new Location(Bukkit.getWorld((String)rs.getString("world_name")), rs.getDouble("min_x"), rs.getDouble("min_y"), rs.getDouble("min_z"));
                Location max = new Location(Bukkit.getWorld((String)rs.getString("world_name")), rs.getDouble("max_x"), rs.getDouble("max_y"), rs.getDouble("max_z"));
                regions.add(new VillagerRegion(rs.getInt("id"), rs.getString("name"), min, max));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return regions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VillagerRegion getRegion(int id) {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM Regions WHERE id = ?");){
            stmt.setInt(1, id);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Location min = new Location(Bukkit.getWorld((String)rs.getString("world_name")), rs.getDouble("min_x"), rs.getDouble("min_y"), rs.getDouble("min_z"));
            Location max = new Location(Bukkit.getWorld((String)rs.getString("world_name")), rs.getDouble("max_x"), rs.getDouble("max_y"), rs.getDouble("max_z"));
            VillagerRegion villagerRegion = new VillagerRegion(rs.getInt("id"), rs.getString("name"), min, max);
            return villagerRegion;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VillagerRegion getRegionByName(String name) {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM Regions WHERE name = ?");){
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Location min = new Location(Bukkit.getWorld((String)rs.getString("world_name")), rs.getDouble("min_x"), rs.getDouble("min_y"), rs.getDouble("min_z"));
            Location max = new Location(Bukkit.getWorld((String)rs.getString("world_name")), rs.getDouble("max_x"), rs.getDouble("max_y"), rs.getDouble("max_z"));
            VillagerRegion villagerRegion = new VillagerRegion(rs.getInt("id"), rs.getString("name"), min, max);
            return villagerRegion;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<Trade> getTradesInRegion(int regionId) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        VillagerRegion region = this.getRegion(regionId);
        if (region == null) {
            return trades;
        }
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM Trades");){
            while (rs.next()) {
                String[] locParts = rs.getString("location").split(",");
                Location loc = new Location((World)Bukkit.getWorlds().get(0), Double.parseDouble(locParts[0]), Double.parseDouble(locParts[1]), Double.parseDouble(locParts[2]));
                if (!region.contains(loc)) continue;
                trades.add(new Trade(rs.getInt("id"), rs.getString("enchant_id_string"), rs.getInt("level"), rs.getInt("price"), loc, rs.getString("description"), region.getName()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return trades;
    }
}

