/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import java.sql.SQLException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.teamck.villagerEnchantTracker.Database;
import org.teamck.villagerEnchantTracker.FindVillagerCommand;
import org.teamck.villagerEnchantTracker.LibrarianDBCommand;
import org.teamck.villagerEnchantTracker.MessageManager;
import org.teamck.villagerEnchantTracker.RegionCommand;
import org.teamck.villagerEnchantTracker.SQLiteDatabase;

public final class VillagerEnchantTracker
extends JavaPlugin {
    private Database db;
    private MessageManager messageManager;

    public void onEnable() {
        try {
            this.saveDefaultConfig();
            this.db = new SQLiteDatabase(this);
            this.messageManager = new MessageManager(this);
            LibrarianDBCommand librarianCommand = new LibrarianDBCommand(this.db, this.messageManager, this);
            this.getCommand("librariandb").setExecutor((CommandExecutor)librarianCommand);
            this.getCommand("librariandb").setTabCompleter((TabCompleter)librarianCommand);
            FindVillagerCommand findVillagerCommand = new FindVillagerCommand(this.messageManager, this, this.db);
            this.getCommand("findvillager").setExecutor((CommandExecutor)findVillagerCommand);
            this.getCommand("findvillager").setTabCompleter((TabCompleter)findVillagerCommand);
            RegionCommand regionCommand = new RegionCommand(this.db, this.messageManager, this);
            this.getCommand("villagerregion").setExecutor((CommandExecutor)regionCommand);
            this.getCommand("villagerregion").setTabCompleter((TabCompleter)regionCommand);
        }
        catch (SQLException e) {
            this.getLogger().severe("Failed to initialize database: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
    }
}

