/*
 * Decompiled with CFR 0.152.
 */
package org.teamck.villagerEnchantTracker;

import org.bukkit.Location;
import org.bukkit.World;

public class VillagerRegion {
    private final int id;
    private final String name;
    private final Location min;
    private final Location max;
    private final World world;

    public VillagerRegion(int id, String name, Location min, Location max) {
        this.id = id;
        this.name = name;
        this.min = min;
        this.max = max;
        this.world = min.getWorld();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Location getMin() {
        return this.min;
    }

    public Location getMax() {
        return this.max;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean contains(Location location) {
        if (location.getWorld() != this.world) {
            return false;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double minX = Math.floor(this.min.getX());
        double minY = Math.floor(this.min.getY());
        double minZ = Math.floor(this.min.getZ());
        double maxX = Math.floor(this.max.getX()) + 1.0;
        double maxY = Math.floor(this.max.getY()) + 1.0;
        double maxZ = Math.floor(this.max.getZ()) + 1.0;
        return x >= minX && x < maxX && y >= minY && y < maxY && z >= minZ && z < maxZ;
    }
}

