/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dceventmanager.config;

import com.jodexindustries.dceventmanager.bootstrap.MainAddon;
import com.jodexindustries.dceventmanager.config.EventConfig;
import com.jodexindustries.dceventmanager.config.PlaceholderConfig;
import com.jodexindustries.donatecase.common.config.ConfigImpl;
import java.io.File;
import lombok.Generated;
import org.spongepowered.configurate.ConfigurateException;

public class ConfigManager {
    private final ConfigImpl config;
    private final EventConfig eventConfig;
    private final PlaceholderConfig placeholderConfig;
    private final MainAddon addon;

    public ConfigManager(MainAddon addon) {
        this.addon = addon;
        File configFile = new File(addon.getDataFolder(), "config.yml");
        File eventFile = new File(addon.getDataFolder(), "events.yml");
        File placeholderFile = new File(addon.getDataFolder(), "placeholders.yml");
        if (!configFile.exists()) {
            addon.saveResource("config.yml", false);
        }
        if (!eventFile.exists()) {
            addon.saveResource("events.yml", false);
        }
        if (!placeholderFile.exists()) {
            addon.saveResource("placeholders.yml", false);
        }
        this.config = new ConfigImpl(configFile);
        this.eventConfig = new EventConfig(eventFile);
        this.placeholderConfig = new PlaceholderConfig(placeholderFile);
    }

    public void load() throws ConfigurateException {
        this.config.load();
        this.eventConfig.load();
        this.placeholderConfig.load();
    }

    @Generated
    public ConfigImpl getConfig() {
        return this.config;
    }

    @Generated
    public EventConfig getEventConfig() {
        return this.eventConfig;
    }

    @Generated
    public PlaceholderConfig getPlaceholderConfig() {
        return this.placeholderConfig;
    }

    @Generated
    public MainAddon getAddon() {
        return this.addon;
    }
}

