/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dceventmanager.data;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class EventData {
    @Setting
    private List<Executor> executors;

    @Generated
    public List<Executor> getExecutors() {
        return this.executors;
    }

    @ConfigSerializable
    public static class Condition {
        @Setting
        private Type type;
        @Setting
        private String placeholder;
        @Setting
        private ConfigurationNode input;

        public boolean compare(@Nullable Object output) {
            Object input = this.input.raw();
            if (input == null || output == null) {
                return false;
            }
            return this.type.compare(input, output);
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String getPlaceholder() {
            return this.placeholder;
        }

        @Generated
        public ConfigurationNode getInput() {
            return this.input;
        }

        public static enum Type {
            EQUALS,
            NOT_EQUAL_TO,
            LESS_THAN,
            LESS_THAN_OR_EQUAL_TO,
            GREATER_THAN,
            GREATER_THAN_OR_EQUAL_TO;

            private static final Map<Type, BiPredicate<Double, Double>> COMPARISON_MAP;

            public boolean compare(@NotNull Object a, @NotNull Object b) {
                Double numA = Type.parseNumber(a);
                Double numB = Type.parseNumber(b);
                if (numA != null && numB != null) {
                    return COMPARISON_MAP.get((Object)this).test(numA, numB);
                }
                return this == EQUALS ? a.equals(b) : this == NOT_EQUAL_TO && !a.equals(b);
            }

            @Nullable
            private static Double parseNumber(@NotNull Object obj) {
                try {
                    return Double.parseDouble(obj.toString().trim());
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
            }

            static {
                COMPARISON_MAP = new EnumMap<Type, BiPredicate<Double, Double>>(Type.class);
                COMPARISON_MAP.put(EQUALS, Double::equals);
                COMPARISON_MAP.put(NOT_EQUAL_TO, (a, b) -> !a.equals(b));
                COMPARISON_MAP.put(LESS_THAN, (a, b) -> a < b);
                COMPARISON_MAP.put(LESS_THAN_OR_EQUAL_TO, (a, b) -> a <= b);
                COMPARISON_MAP.put(GREATER_THAN, (a, b) -> a > b);
                COMPARISON_MAP.put(GREATER_THAN_OR_EQUAL_TO, (a, b) -> a >= b);
            }
        }
    }

    @ConfigSerializable
    public static class Executor {
        @Setting
        private String name;
        @Setting
        private List<Condition> conditions;
        @Setting
        private List<String> actions;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Condition> getConditions() {
            return this.conditions;
        }

        @Generated
        public List<String> getActions() {
            return this.actions;
        }
    }
}

