/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dceventmanager.event;

import com.jodexindustries.dceventmanager.data.EventData;
import com.jodexindustries.dceventmanager.data.EventPlaceholder;
import com.jodexindustries.dceventmanager.utils.Reflection;
import com.jodexindustries.dceventmanager.utils.Tools;
import com.jodexindustries.donatecase.api.event.DCEvent;
import com.jodexindustries.donatecase.api.event.plugin.DonateCaseReloadEvent;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.tools.DCTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.event.EventSubscriber;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;

public class DCEventExecutor
implements EventSubscriber<DCEvent> {
    public final Class<? extends DCEvent> clazz;
    public final String name;
    public final Tools tools;

    public DCEventExecutor(Class<? extends DCEvent> clazz, Tools tools) {
        this.clazz = clazz;
        this.name = clazz.getSimpleName();
        this.tools = tools;
    }

    public void invoke(@NonNull DCEvent event) {
        EventData data;
        DonateCaseReloadEvent reloadEvent;
        if (event instanceof DonateCaseReloadEvent && (reloadEvent = (DonateCaseReloadEvent)event).type() == DonateCaseReloadEvent.Type.CONFIG) {
            this.tools.loadConfig();
        }
        if ((data = this.tools.getConfigManager().getEventConfig().getEvents().get(this.name)) == null) {
            return;
        }
        Map<String, EventPlaceholder> placeholderMap = this.tools.getConfigManager().getPlaceholderConfig().getEventPlaceholders();
        EventPlaceholder eventPlaceholder = placeholderMap.getOrDefault(this.name, new EventPlaceholder());
        List<EventPlaceholder.Placeholder> placeholders = eventPlaceholder.getPlaceholders();
        Map<String, Object> parsedPlaceholders = this.getPlaceholders(event, placeholders);
        for (EventData.Executor executor : data.getExecutors()) {
            try {
                DCPlayer player = this.getPlayer(event, placeholders);
                if (!this.checkConditions(player, executor.getConditions(), parsedPlaceholders)) continue;
                this.executeActions(event, player, this.replaceList(executor.getActions(), parsedPlaceholders));
            }
            catch (Exception e) {
                this.tools.main.getLogger().log(Level.WARNING, "Error with executing executor: " + executor.getName(), (Throwable)e);
            }
        }
    }

    private boolean checkConditions(@Nullable DCPlayer player, List<EventData.Condition> conditions, Map<String, Object> placeholders) {
        return conditions.stream().allMatch(condition -> {
            Object output = placeholders.getOrDefault(condition.getPlaceholder(), player != null ? this.tools.api.getPlatform().getPAPI().setPlaceholders(player, condition.getPlaceholder()) : null);
            return condition.compare(output);
        });
    }

    private Map<String, Object> getPlaceholders(DCEvent event, List<EventPlaceholder.Placeholder> placeholders) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (placeholders == null) {
            return map;
        }
        for (EventPlaceholder.Placeholder placeholder : placeholders) {
            map.computeIfAbsent(placeholder.getReplace(), key -> {
                try {
                    return Reflection.invokeMethodChain(event, placeholder.getMethod());
                }
                catch (Exception ex) {
                    this.tools.main.getLogger().log(Level.WARNING, "Failed to parse placeholder: " + placeholder.getName(), (Throwable)ex);
                    return null;
                }
            });
        }
        return map;
    }

    private void executeActions(DCEvent event, @Nullable DCPlayer player, List<String> actions) {
        if (player != null) {
            this.tools.api.getActionManager().execute(player, actions);
        }
        actions.stream().filter(action -> action.startsWith("[invoke]")).forEach(action -> {
            try {
                Reflection.invokeMethodChain(event, action.substring(8).trim());
            }
            catch (Exception e) {
                this.tools.main.getLogger().log(Level.WARNING, "Error executing action: " + action, (Throwable)e);
            }
        });
    }

    @Nullable
    private DCPlayer getPlayer(DCEvent event, List<EventPlaceholder.Placeholder> placeholders) {
        if (placeholders == null) {
            return null;
        }
        return placeholders.stream().filter(placeholder -> "player".equals(placeholder.getName())).findFirst().map(placeholder -> {
            try {
                Object player = Reflection.invokeMethodChain(event, placeholder.getMethod().replace("#getName", ""));
                return player instanceof DCPlayer ? (DCPlayer)player : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }).orElse(null);
    }

    private List<String> replaceList(List<String> list, Map<String, Object> map) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().map(line -> {
            StringBuilder sb = new StringBuilder((String)line);
            map.forEach((key, value) -> {
                int index;
                while ((index = sb.indexOf((String)key)) != -1) {
                    sb.replace(index, index + key.length(), String.valueOf(value));
                }
            });
            return DCTools.rc((String)sb.toString());
        }).collect(Collectors.toList());
    }
}

